var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, forwardRef } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/common';
import { isNumber, padNumber, toInteger } from '../util/util';
import { NgbTime } from './ngb-time';
const NGB_TIMEPICKER_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => NgbTimepicker),
    multi: true
};
/**
 * A lightweight & configurable timepicker directive.
 */
export let NgbTimepicker = class NgbTimepicker {
    constructor() {
        /**
         * Whether to display 12H or 24H mode.
         */
        this.meridian = false;
        /**
         * Whether to display seconds input.
         */
        this.seconds = false;
        /**
         * Number of hours to increase or decrease when using a button.
         */
        this.hourStep = 1;
        /**
         * Number of minutes to increase or decrease when using a button.
         */
        this.minuteStep = 1;
        /**
         * Number of seconds to increase or decrease when using a button.
         */
        this.secondStep = 1;
        /**
         * To disable timepicker
         */
        this.disabled = false;
        /**
         * To make timepicker readonly
         */
        this.readonlyInputs = false;
        this.onChange = (_) => { };
        this.onTouched = () => { };
    }
    writeValue(value) { this.model = value ? new NgbTime(value.hour, value.minute, value.second) : new NgbTime(); }
    registerOnChange(fn) { this.onChange = fn; }
    registerOnTouched(fn) { this.onTouched = fn; }
    changeHour(step) {
        this.model.changeHour(step);
        this.propagateModelChange();
    }
    changeMinute(step) {
        this.model.changeMinute(step);
        this.propagateModelChange();
    }
    changeSecond(step) {
        this.model.changeSecond(step);
        this.propagateModelChange();
    }
    updateHour(newVal) {
        this.model.updateHour(toInteger(newVal) || 0);
        this.propagateModelChange();
    }
    updateMinute(newVal) {
        this.model.updateMinute(toInteger(newVal) || 0);
        this.propagateModelChange();
    }
    updateSecond(newVal) {
        this.model.updateSecond(toInteger(newVal) || 0);
        this.propagateModelChange();
    }
    toggleMeridian() {
        if (this.meridian) {
            this.changeHour(12);
        }
    }
    formatHour(value) { return padNumber(isNumber(value) ? (value % (this.meridian ? 12 : 24)) : NaN); }
    formatMinSec(value) { return padNumber(value); }
    propagateModelChange() {
        this.onTouched();
        this.onChange({ hour: this.model.hour, minute: this.model.minute, second: this.model.second });
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTimepicker.prototype, "meridian", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTimepicker.prototype, "seconds", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTimepicker.prototype, "hourStep", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTimepicker.prototype, "minuteStep", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTimepicker.prototype, "secondStep", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTimepicker.prototype, "disabled", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTimepicker.prototype, "readonlyInputs", void 0);
NgbTimepicker = __decorate([
    Component({
        selector: 'ngb-timepicker',
        styles: [`
    .chevron::before {
      border-style: solid;
      border-width: 0.29em 0.29em 0 0;
      content: '';
      display: inline-block;
      height: 0.69em;
      left: 0.05em;
      position: relative;
      top: 0.15em;
      transform: rotate(-45deg);
      vertical-align: middle;
      width: 0.71em;
    }
    
    .chevron.bottom:before {
      top: -.3em;
      transform: rotate(135deg);
    }
    
    .btn-link {
      outline: 0;
    }

    .btn-link.disabled {
      cursor: not-allowed;
      opacity: .65;
    }
  `],
        template: `
     <fieldset [disabled]="disabled" [class.disabled]="disabled">
      <table>
        <tr>
          <td class="text-xs-center">
            <button class="btn-link" (click)="changeHour(hourStep)"
              [class.disabled]="disabled">
              <span class="chevron"></span>
            </button>
          </td>
          <td>&nbsp;</td>
          <td class="text-xs-center">
            <button class="btn-link" (click)="changeMinute(minuteStep)"
              [class.disabled]="disabled">
                <span class="chevron"></span>
            </button>
          </td>
          <template [ngIf]="seconds">
            <td>&nbsp;</td>
            <td class="text-xs-center">
              <button class="btn-link" (click)="changeSecond(secondStep)"
                [class.disabled]="disabled">
                <span class="chevron"></span>
              </button>
            </td>
          </template>
          <template [ngIf]="meridian">
            <td>&nbsp;</td>
            <td>&nbsp;</td>
          </template>
        </tr>
        <tr>
          <td>
            <input type="text" class="form-control" maxlength="2" size="2" placeholder="HH"
              [ngModel]="formatHour(model?.hour)" (ngModelChange)="updateHour($event)" 
              [readonly]="readonlyInputs">
          </td>
          <td>&nbsp;:&nbsp;</td>
          <td>
            <input type="text" class="form-control" maxlength="2" size="2" placeholder="MM"
              [ngModel]="formatMinSec(model?.minute)" (ngModelChange)="updateMinute($event)" 
              [readonly]="readonlyInputs">
          </td>
          <template [ngIf]="seconds">
            <td>&nbsp;:&nbsp;</td>
            <input type="text" class="form-control" maxlength="2" size="2" placeholder="SS"
              [ngModel]="formatMinSec(model?.second)" (ngModelChange)="updateSecond($event)" 
              [readonly]="readonlyInputs">
          </template>
          <template [ngIf]="meridian">
            <td>&nbsp;&nbsp;</td>
            <td>
              <button class="btn btn-outline-primary" (click)="toggleMeridian()">{{model.hour > 12 ? 'PM' : 'AM'}}</button>
            </td>
          </template>
        </tr>
        <tr>
          <td class="text-xs-center">
            <button class="btn-link" (click)="changeHour(-hourStep)" 
              [class.disabled]="disabled">
              <span class="chevron bottom"></span>
            </button>
          </td>
          <td>&nbsp;</td>
          <td class="text-xs-center">
            <button class="btn-link" (click)="changeMinute(-minuteStep)"
              [class.disabled]="disabled">
              <span class="chevron bottom"></span>
            </button>
          </td>
          <template [ngIf]="seconds">
            <td>&nbsp;</td>
            <td class="text-xs-center">
              <button class="btn-link" (click)="changeSecond(-secondStep)"
                [class.disabled]="disabled">
                <span class="chevron bottom"></span>
              </button>
            </td>
          </template>
          <template [ngIf]="meridian">
            <td>&nbsp;</td>
            <td>&nbsp;</td>
          </template>
        </tr>
      </table>
    </fieldset>
  `,
        providers: [NGB_TIMEPICKER_VALUE_ACCESSOR]
    }), 
    __metadata('design:paramtypes', [])
], NgbTimepicker);
export const NGB_TIMEPICKER_DIRECTIVES = [NgbTimepicker];

//# sourceMappingURL=timepicker.js.map
