"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var util_1 = require('../util/util');
/**
 * A directive that will take care of visualising a pagination bar and enable / disable buttons correctly!
 */
var NgbPagination = (function () {
    function NgbPagination() {
        this._boundaryLinks = false;
        this._directionLinks = true;
        this._ellipses = true;
        this._maxSize = 0;
        this._page = 0;
        this._pageCount = 0;
        this._pageSize = 10;
        this._rotate = false;
        this.pages = [];
        /**
         *  An event fired when the page is changed.
         *  Event's payload equals the current page.
         */
        this.pageChange = new core_1.EventEmitter();
    }
    Object.defineProperty(NgbPagination.prototype, "boundaryLinks", {
        get: function () { return this._boundaryLinks; },
        /**
         *  Whether to show the "First" and "Last" page links
         */
        set: function (value) {
            this._boundaryLinks = util_1.toBoolean(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgbPagination.prototype, "directionLinks", {
        get: function () { return this._directionLinks; },
        /**
         *  Whether to show the "Next" and "Previous" page links
         */
        set: function (value) {
            this._directionLinks = util_1.toBoolean(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgbPagination.prototype, "ellipses", {
        get: function () { return this._ellipses; },
        /**
         *  Whether to show ellipsis symbols and first/last page numbers when maxSize > number of pages
         */
        set: function (value) {
            this._ellipses = util_1.toBoolean(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgbPagination.prototype, "collectionSize", {
        get: function () { return this._collectionSize; },
        /**
         *  Number of items in collection.
         */
        set: function (value) {
            this._collectionSize = util_1.toInteger(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgbPagination.prototype, "maxSize", {
        get: function () { return this._maxSize; },
        /**
         *  Maximum number of pages to display
         */
        set: function (value) {
            this._maxSize = util_1.toInteger(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgbPagination.prototype, "page", {
        get: function () { return this._page; },
        /**
         *  Current page.
         */
        set: function (value) {
            this._page = parseInt("" + value, 10);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgbPagination.prototype, "pageSize", {
        get: function () { return this._pageSize; },
        /**
         *  Number of items per page.
         */
        set: function (value) {
            this._pageSize = util_1.toInteger(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgbPagination.prototype, "rotate", {
        get: function () { return this._rotate; },
        /**
         *  Whether to rotate pages when maxSize > number of pages.
         *  Current page will be in the middle
         */
        set: function (value) {
            this._rotate = util_1.toBoolean(value);
        },
        enumerable: true,
        configurable: true
    });
    NgbPagination.prototype.hasPrevious = function () { return this.page > 1; };
    NgbPagination.prototype.hasNext = function () { return this.page < this._pageCount; };
    NgbPagination.prototype.selectPage = function (pageNumber) {
        var prevPageNo = this.page;
        this._page = this._getPageNoInRange(pageNumber);
        if (this.page !== prevPageNo) {
            this.pageChange.emit(this.page);
        }
        this.ngOnChanges();
    };
    NgbPagination.prototype.ngOnChanges = function () {
        // re-calculate new length of pages
        this._pageCount = Math.ceil(this._collectionSize / this._pageSize);
        // fill-in model needed to render pages
        this.pages.length = 0;
        for (var i = 1; i <= this._pageCount; i++) {
            this.pages.push(i);
        }
        // get selected page
        this._page = this._getPageNoInRange(this.page);
        // apply maxSize if necessary
        if (this._maxSize > 0 && this._pageCount > this._maxSize) {
            var start = 0;
            var end = this._pageCount;
            // either paginating or rotating page numbers
            if (this._rotate) {
                _a = this._applyRotation(), start = _a[0], end = _a[1];
            }
            else {
                _b = this._applyPagination(), start = _b[0], end = _b[1];
            }
            this.pages = this.pages.slice(start, end);
            // adding ellipses
            this._applyEllipses(start, end);
        }
        var _a, _b;
    };
    /**
     * Appends ellipses and first/last page number to the displayed pages
     */
    NgbPagination.prototype._applyEllipses = function (start, end) {
        if (this._ellipses) {
            if (start > 0) {
                this.pages.unshift(-1);
                this.pages.unshift(1);
            }
            if (end < this._pageCount) {
                this.pages.push(-1);
                this.pages.push(this._pageCount);
            }
        }
    };
    /**
     * Rotates page numbers based on maxSize items visible.
     * Currently selected page stays in the middle:
     *
     * Ex. for selected page = 6:
     * [5,*6*,7] for maxSize = 3
     * [4,5,*6*,7] for maxSize = 4
     */
    NgbPagination.prototype._applyRotation = function () {
        var start = 0;
        var end = this._pageCount;
        var leftOffset = Math.floor(this._maxSize / 2);
        var rightOffset = this._maxSize % 2 === 0 ? leftOffset - 1 : leftOffset;
        if (this._page <= leftOffset) {
            // very beginning, no rotation -> [0..maxSize]
            end = this._maxSize;
        }
        else if (this._pageCount - this._page < leftOffset) {
            // very end, no rotation -> [len-maxSize..len]
            start = this._pageCount - this._maxSize;
        }
        else {
            // rotate
            start = this._page - leftOffset - 1;
            end = this._page + rightOffset;
        }
        return [start, end];
    };
    /**
     * Paginates page numbers based on maxSize items per page
     */
    NgbPagination.prototype._applyPagination = function () {
        var page = Math.ceil(this._page / this._maxSize) - 1;
        var start = page * this._maxSize;
        var end = start + this._maxSize;
        return [start, end];
    };
    NgbPagination.prototype._isEllipsis = function (pageNumber) { return pageNumber === -1; };
    NgbPagination.prototype._getPageNoInRange = function (newPageNo) { return util_1.getValueInRange(newPageNo, this._pageCount, 1); };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean), 
        __metadata('design:paramtypes', [Boolean])
    ], NgbPagination.prototype, "boundaryLinks", null);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean), 
        __metadata('design:paramtypes', [Boolean])
    ], NgbPagination.prototype, "directionLinks", null);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean), 
        __metadata('design:paramtypes', [Boolean])
    ], NgbPagination.prototype, "ellipses", null);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object), 
        __metadata('design:paramtypes', [Object])
    ], NgbPagination.prototype, "collectionSize", null);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object), 
        __metadata('design:paramtypes', [Object])
    ], NgbPagination.prototype, "maxSize", null);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object), 
        __metadata('design:paramtypes', [Object])
    ], NgbPagination.prototype, "page", null);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object), 
        __metadata('design:paramtypes', [Object])
    ], NgbPagination.prototype, "pageSize", null);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbPagination.prototype, "pageChange", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean), 
        __metadata('design:paramtypes', [Boolean])
    ], NgbPagination.prototype, "rotate", null);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPagination.prototype, "size", void 0);
    NgbPagination = __decorate([
        core_1.Component({
            selector: 'ngb-pagination',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            template: "\n    <nav>\n      <ul [class]=\"'pagination' + (size ? ' pagination-' + size : '')\">\n        <li *ngIf=\"boundaryLinks\" class=\"page-item\" [class.disabled]=\"!hasPrevious()\">\n          <a aria-label=\"First\" class=\"page-link\" href (click)=\"!!selectPage(1)\">\n            <span aria-hidden=\"true\">&laquo;&laquo;</span>\n            <span class=\"sr-only\">First</span>\n          </a>                \n        </li>\n      \n        <li *ngIf=\"directionLinks\" class=\"page-item\" [class.disabled]=\"!hasPrevious()\">\n          <a aria-label=\"Previous\" class=\"page-link\" href (click)=\"!!selectPage(page-1)\">\n            <span aria-hidden=\"true\">&laquo;</span>\n            <span class=\"sr-only\">Previous</span>\n          </a>\n        </li>\n\n        <li *ngFor=\"let pageNumber of pages\" class=\"page-item\" [class.active]=\"pageNumber === page\" \n          [class.disabled]=\"_isEllipsis(pageNumber)\">\n          <a *ngIf=\"_isEllipsis(pageNumber)\" class=\"page-link\">...</a>\n          <a *ngIf=\"!_isEllipsis(pageNumber)\" class=\"page-link\" href (click)=\"!!selectPage(pageNumber)\">{{pageNumber}}</a>\n        </li>\n\n        <li *ngIf=\"directionLinks\" class=\"page-item\" [class.disabled]=\"!hasNext()\">\n          <a aria-label=\"Next\" class=\"page-link\" href (click)=\"!!selectPage(page+1)\">\n            <span aria-hidden=\"true\">&raquo;</span>\n            <span class=\"sr-only\">Next</span>\n          </a>\n        </li>\n        \n        <li *ngIf=\"boundaryLinks\" class=\"page-item\" [class.disabled]=\"!hasNext()\">\n          <a aria-label=\"Last\" class=\"page-link\" href (click)=\"!!selectPage(_pageCount)\">\n            <span aria-hidden=\"true\">&raquo;&raquo;</span>\n            <span class=\"sr-only\">Last</span>\n          </a>                \n        </li>        \n      </ul>\n    </nav>\n  "
        }), 
        __metadata('design:paramtypes', [])
    ], NgbPagination);
    return NgbPagination;
}());
exports.NgbPagination = NgbPagination;
exports.NGB_PAGINATION_DIRECTIVES = [NgbPagination];

//# sourceMappingURL=pagination.js.map
