"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
/**
 * Rating directive that will take care of visualising a star rating bar.
 */
var NgbRating = (function () {
    function NgbRating() {
        this.range = [];
        /**
         * Maximal rating that can be given using this widget.
         */
        this.max = 10;
        /**
         * A flag indicating if rating can be updated.
         */
        this.readonly = false;
        /**
         * An event fired when a user is hovering over a given rating.
         * Event's payload equals to the rating being hovered over.
         */
        this.hover = new core_1.EventEmitter();
        /**
         * An event fired when a user stops hovering over a given rating.
         * Event's payload equals to the rating of the last item being hovered over.
         */
        this.leave = new core_1.EventEmitter();
        /**
         * An event fired when a user selects a new rating.
         * Event's payload equals to the newly selected rating.
         */
        this.rateChange = new core_1.EventEmitter();
    }
    NgbRating.prototype.enter = function (value) {
        if (!this.readonly) {
            this.rate = value;
        }
        this.hover.emit(value);
    };
    NgbRating.prototype.ngOnInit = function () {
        this._oldRate = this.rate;
        this.range = this._buildTemplateObjects();
    };
    NgbRating.prototype.reset = function () {
        this.leave.emit(this.rate);
        this.rate = this._oldRate;
    };
    NgbRating.prototype.update = function (value) {
        if (!this.readonly) {
            this._oldRate = value;
            this.rate = value;
            this.rateChange.emit(value);
        }
    };
    NgbRating.prototype._buildTemplateObjects = function () {
        var range = [];
        for (var i = 1; i <= this.max; i++) {
            range.push({ title: i });
        }
        return range;
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], NgbRating.prototype, "max", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], NgbRating.prototype, "rate", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbRating.prototype, "readonly", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbRating.prototype, "hover", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbRating.prototype, "leave", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbRating.prototype, "rateChange", void 0);
    NgbRating = __decorate([
        core_1.Component({
            selector: 'ngb-rating',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            template: "\n    <span tabindex=\"0\" (mouseleave)=\"reset()\" aria-valuemin=\"0\" [attr.aria-valuemax]=\"max\" [attr.aria-valuenow]=\"rate\">\n      <template ngFor let-r [ngForOf]=\"range\" let-index=\"index\">\n        <span class=\"sr-only\">({{ index < rate ? '*' : ' ' }})</span>\n        <span (mouseenter)=\"enter(index + 1)\" (click)=\"update(index + 1)\" [title]=\"r.title\" \n        [attr.aria-valuetext]=\"r.title\" \n        [style.cursor]=\"readonly ? 'not-allowed' : 'pointer'\">{{ index < rate ? '&#9733;' : '&#9734;' }}</span>\n      </template>\n    </span>\n  "
        }), 
        __metadata('design:paramtypes', [])
    ], NgbRating);
    return NgbRating;
}());
exports.NgbRating = NgbRating;
exports.NGB_RATING_DIRECTIVES = [NgbRating];

//# sourceMappingURL=rating.js.map
