"use strict";
var util_1 = require('../util/util');
var NgbTime = (function () {
    function NgbTime(hour, minute, second) {
        this.hour = util_1.toInteger(hour);
        this.minute = util_1.toInteger(minute);
        this.second = util_1.toInteger(second);
    }
    NgbTime.prototype.changeHour = function (step) {
        if (step === void 0) { step = 1; }
        this.updateHour((isNaN(this.hour) ? 0 : this.hour) + step);
    };
    NgbTime.prototype.updateHour = function (hour) { this.hour = (hour < 0 ? 24 + hour : hour) % 24; };
    NgbTime.prototype.changeMinute = function (step) {
        if (step === void 0) { step = 1; }
        this.updateMinute((isNaN(this.minute) ? 0 : this.minute) + step);
    };
    NgbTime.prototype.updateMinute = function (minute) {
        this.minute = minute % 60 < 0 ? 60 + minute % 60 : minute % 60;
        this.changeHour(Math.floor(minute / 60));
    };
    NgbTime.prototype.changeSecond = function (step) {
        if (step === void 0) { step = 1; }
        this.updateSecond((isNaN(this.second) ? 0 : this.second) + step);
    };
    NgbTime.prototype.updateSecond = function (second) {
        this.second = second < 0 ? 60 + second % 60 : second % 60;
        this.changeMinute(Math.floor(second / 60));
    };
    NgbTime.prototype.toString = function () { return (this.hour || 0) + ":" + (this.minute || 0) + ":" + (this.second || 0); };
    return NgbTime;
}());
exports.NgbTime = NgbTime;

//# sourceMappingURL=ngb-time.js.map
