"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var common_1 = require('@angular/common');
var util_1 = require('../util/util');
var ngb_time_1 = require('./ngb-time');
var NGB_TIMEPICKER_VALUE_ACCESSOR = {
    provide: common_1.NG_VALUE_ACCESSOR,
    useExisting: core_1.forwardRef(function () { return NgbTimepicker; }),
    multi: true
};
/**
 * A lightweight & configurable timepicker directive.
 */
var NgbTimepicker = (function () {
    function NgbTimepicker() {
        /**
         * Whether to display 12H or 24H mode.
         */
        this.meridian = false;
        /**
         * Whether to display seconds input.
         */
        this.seconds = false;
        /**
         * Number of hours to increase or decrease when using a button.
         */
        this.hourStep = 1;
        /**
         * Number of minutes to increase or decrease when using a button.
         */
        this.minuteStep = 1;
        /**
         * Number of seconds to increase or decrease when using a button.
         */
        this.secondStep = 1;
        /**
         * To disable timepicker
         */
        this.disabled = false;
        /**
         * To make timepicker readonly
         */
        this.readonlyInputs = false;
        this.onChange = function (_) { };
        this.onTouched = function () { };
    }
    NgbTimepicker.prototype.writeValue = function (value) { this.model = value ? new ngb_time_1.NgbTime(value.hour, value.minute, value.second) : new ngb_time_1.NgbTime(); };
    NgbTimepicker.prototype.registerOnChange = function (fn) { this.onChange = fn; };
    NgbTimepicker.prototype.registerOnTouched = function (fn) { this.onTouched = fn; };
    NgbTimepicker.prototype.changeHour = function (step) {
        this.model.changeHour(step);
        this.propagateModelChange();
    };
    NgbTimepicker.prototype.changeMinute = function (step) {
        this.model.changeMinute(step);
        this.propagateModelChange();
    };
    NgbTimepicker.prototype.changeSecond = function (step) {
        this.model.changeSecond(step);
        this.propagateModelChange();
    };
    NgbTimepicker.prototype.updateHour = function (newVal) {
        this.model.updateHour(util_1.toInteger(newVal) || 0);
        this.propagateModelChange();
    };
    NgbTimepicker.prototype.updateMinute = function (newVal) {
        this.model.updateMinute(util_1.toInteger(newVal) || 0);
        this.propagateModelChange();
    };
    NgbTimepicker.prototype.updateSecond = function (newVal) {
        this.model.updateSecond(util_1.toInteger(newVal) || 0);
        this.propagateModelChange();
    };
    NgbTimepicker.prototype.toggleMeridian = function () {
        if (this.meridian) {
            this.changeHour(12);
        }
    };
    NgbTimepicker.prototype.formatHour = function (value) { return util_1.padNumber(util_1.isNumber(value) ? (value % (this.meridian ? 12 : 24)) : NaN); };
    NgbTimepicker.prototype.formatMinSec = function (value) { return util_1.padNumber(value); };
    NgbTimepicker.prototype.propagateModelChange = function () {
        this.onTouched();
        this.onChange({ hour: this.model.hour, minute: this.model.minute, second: this.model.second });
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTimepicker.prototype, "meridian", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTimepicker.prototype, "seconds", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTimepicker.prototype, "hourStep", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTimepicker.prototype, "minuteStep", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTimepicker.prototype, "secondStep", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTimepicker.prototype, "disabled", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTimepicker.prototype, "readonlyInputs", void 0);
    NgbTimepicker = __decorate([
        core_1.Component({
            selector: 'ngb-timepicker',
            styles: ["\n    .chevron::before {\n      border-style: solid;\n      border-width: 0.29em 0.29em 0 0;\n      content: '';\n      display: inline-block;\n      height: 0.69em;\n      left: 0.05em;\n      position: relative;\n      top: 0.15em;\n      transform: rotate(-45deg);\n      vertical-align: middle;\n      width: 0.71em;\n    }\n    \n    .chevron.bottom:before {\n      top: -.3em;\n      transform: rotate(135deg);\n    }\n    \n    .btn-link {\n      outline: 0;\n    }\n\n    .btn-link.disabled {\n      cursor: not-allowed;\n      opacity: .65;\n    }\n  "],
            template: "\n     <fieldset [disabled]=\"disabled\" [class.disabled]=\"disabled\">\n      <table>\n        <tr>\n          <td class=\"text-xs-center\">\n            <button class=\"btn-link\" (click)=\"changeHour(hourStep)\"\n              [class.disabled]=\"disabled\">\n              <span class=\"chevron\"></span>\n            </button>\n          </td>\n          <td>&nbsp;</td>\n          <td class=\"text-xs-center\">\n            <button class=\"btn-link\" (click)=\"changeMinute(minuteStep)\"\n              [class.disabled]=\"disabled\">\n                <span class=\"chevron\"></span>\n            </button>\n          </td>\n          <template [ngIf]=\"seconds\">\n            <td>&nbsp;</td>\n            <td class=\"text-xs-center\">\n              <button class=\"btn-link\" (click)=\"changeSecond(secondStep)\"\n                [class.disabled]=\"disabled\">\n                <span class=\"chevron\"></span>\n              </button>\n            </td>\n          </template>\n          <template [ngIf]=\"meridian\">\n            <td>&nbsp;</td>\n            <td>&nbsp;</td>\n          </template>\n        </tr>\n        <tr>\n          <td>\n            <input type=\"text\" class=\"form-control\" maxlength=\"2\" size=\"2\" placeholder=\"HH\"\n              [ngModel]=\"formatHour(model?.hour)\" (ngModelChange)=\"updateHour($event)\" \n              [readonly]=\"readonlyInputs\">\n          </td>\n          <td>&nbsp;:&nbsp;</td>\n          <td>\n            <input type=\"text\" class=\"form-control\" maxlength=\"2\" size=\"2\" placeholder=\"MM\"\n              [ngModel]=\"formatMinSec(model?.minute)\" (ngModelChange)=\"updateMinute($event)\" \n              [readonly]=\"readonlyInputs\">\n          </td>\n          <template [ngIf]=\"seconds\">\n            <td>&nbsp;:&nbsp;</td>\n            <input type=\"text\" class=\"form-control\" maxlength=\"2\" size=\"2\" placeholder=\"SS\"\n              [ngModel]=\"formatMinSec(model?.second)\" (ngModelChange)=\"updateSecond($event)\" \n              [readonly]=\"readonlyInputs\">\n          </template>\n          <template [ngIf]=\"meridian\">\n            <td>&nbsp;&nbsp;</td>\n            <td>\n              <button class=\"btn btn-outline-primary\" (click)=\"toggleMeridian()\">{{model.hour > 12 ? 'PM' : 'AM'}}</button>\n            </td>\n          </template>\n        </tr>\n        <tr>\n          <td class=\"text-xs-center\">\n            <button class=\"btn-link\" (click)=\"changeHour(-hourStep)\" \n              [class.disabled]=\"disabled\">\n              <span class=\"chevron bottom\"></span>\n            </button>\n          </td>\n          <td>&nbsp;</td>\n          <td class=\"text-xs-center\">\n            <button class=\"btn-link\" (click)=\"changeMinute(-minuteStep)\"\n              [class.disabled]=\"disabled\">\n              <span class=\"chevron bottom\"></span>\n            </button>\n          </td>\n          <template [ngIf]=\"seconds\">\n            <td>&nbsp;</td>\n            <td class=\"text-xs-center\">\n              <button class=\"btn-link\" (click)=\"changeSecond(-secondStep)\"\n                [class.disabled]=\"disabled\">\n                <span class=\"chevron bottom\"></span>\n              </button>\n            </td>\n          </template>\n          <template [ngIf]=\"meridian\">\n            <td>&nbsp;</td>\n            <td>&nbsp;</td>\n          </template>\n        </tr>\n      </table>\n    </fieldset>\n  ",
            providers: [NGB_TIMEPICKER_VALUE_ACCESSOR]
        }), 
        __metadata('design:paramtypes', [])
    ], NgbTimepicker);
    return NgbTimepicker;
}());
exports.NgbTimepicker = NgbTimepicker;
exports.NGB_TIMEPICKER_DIRECTIVES = [NgbTimepicker];

//# sourceMappingURL=timepicker.js.map
