import { OnInit, AfterViewChecked, OnDestroy, Injector, Renderer, ElementRef, TemplateRef, ViewContainerRef, ComponentFactoryResolver } from '@angular/core';
export declare class NgbTooltipWindow {
    placement: string;
}
/**
 * A lightweight, extensible directive for fancy tooltip creation.
 */
export declare class NgbTooltip implements OnInit, AfterViewChecked, OnDestroy {
    private _elementRef;
    private _renderer;
    /**
     * Content to be displayed as tooltip.
     */
    ngbTooltip: string | TemplateRef<any>;
    /**
     * Placement of a tooltip. Accepts: "top", "bottom", "left", "right"
     */
    placement: string;
    /**
     * Specifies events that should trigger. Supports a space separated list of event names.
     */
    triggers: string;
    private _popupService;
    private _positioning;
    private _windowRef;
    private _unregisterListenersFn;
    constructor(_elementRef: ElementRef, _renderer: Renderer, injector: Injector, componentFactoryResolver: ComponentFactoryResolver, viewContainerRef: ViewContainerRef);
    open(): void;
    close(): void;
    toggle(): void;
    ngOnInit(): void;
    ngAfterViewChecked(): void;
    ngOnDestroy(): void;
}
export declare const NGB_TOOLTIP_DIRECTIVES: typeof NgbTooltip[];
