"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var Rx_1 = require('rxjs/Rx');
require('rxjs/add/operator/let');
var positioning_1 = require('../util/positioning');
var typeahead_window_1 = require('./typeahead-window');
var popup_1 = require('../util/popup');
var common_1 = require('@angular/common');
var util_1 = require('../util/util');
var Key;
(function (Key) {
    Key[Key["Tab"] = 9] = "Tab";
    Key[Key["Enter"] = 13] = "Enter";
    Key[Key["Escape"] = 27] = "Escape";
    Key[Key["ArrowUp"] = 38] = "ArrowUp";
    Key[Key["ArrowDown"] = 40] = "ArrowDown";
})(Key || (Key = {}));
var NGB_TYPEAHEAD_VALUE_ACCESSOR = {
    provide: common_1.NG_VALUE_ACCESSOR,
    useExisting: core_1.forwardRef(function () { return NgbTypeahead; }),
    multi: true
};
/**
 * NgbTypeahead directive provides a simple way of creating powerful typeaheads from any text input
 */
var NgbTypeahead = (function () {
    function NgbTypeahead(_elementRef, _viewContainerRef, _renderer, _injector, componentFactoryResolver) {
        var _this = this;
        this._elementRef = _elementRef;
        this._viewContainerRef = _viewContainerRef;
        this._renderer = _renderer;
        this._injector = _injector;
        this._positioning = new positioning_1.Positioning();
        this._valueChanges = new Rx_1.Subject();
        this.onChange = function (value) {
            _this._onChangeNoEmit(value);
            _this._valueChanges.next(value);
        };
        this.onTouched = function () { };
        this._popupService = new popup_1.PopupService(typeahead_window_1.NgbTypeaheadWindow, _injector, _viewContainerRef, _renderer, componentFactoryResolver);
        this._onChangeNoEmit = function (_) { };
    }
    NgbTypeahead.prototype.ngAfterViewChecked = function () {
        if (this._windowRef) {
            var targetPosition = this._positioning.positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, 'bottom-left', false);
            var targetStyle = this._windowRef.location.nativeElement.style;
            targetStyle.top = targetPosition.top + "px";
            targetStyle.left = targetPosition.left + "px";
        }
    };
    NgbTypeahead.prototype.ngOnInit = function () {
        var _this = this;
        this._valueChanges.let(this.ngbTypeahead).subscribe(function (results) {
            if (!results || results.length === 0) {
                _this._closePopup();
            }
            else {
                _this._openPopup();
                _this._windowRef.instance.results = results;
                _this._windowRef.instance.term = _this._elementRef.nativeElement.value;
                if (_this.resultFormatter) {
                    _this._windowRef.instance.formatter = _this.resultFormatter;
                }
                if (_this.resultTemplate) {
                    _this._windowRef.instance.resultTemplate = _this.resultTemplate;
                }
            }
        });
    };
    NgbTypeahead.prototype.registerOnChange = function (fn) { this._onChangeNoEmit = fn; };
    NgbTypeahead.prototype.registerOnTouched = function (fn) { this.onTouched = fn; };
    NgbTypeahead.prototype.writeValue = function (value) {
        var formattedValue = value && this.inputFormatter ? this.inputFormatter(value) : util_1.toString(value);
        this._renderer.setElementProperty(this._elementRef.nativeElement, 'value', formattedValue);
    };
    NgbTypeahead.prototype._closePopup = function () {
        this._popupService.close();
        this._windowRef = null;
    };
    NgbTypeahead.prototype._handleKeyDown = function (event) {
        if (!this._windowRef) {
            return;
        }
        if (Key[util_1.toString(event.which)]) {
            event.preventDefault();
            switch (event.which) {
                case Key.ArrowDown:
                    this._windowRef.instance.next();
                    break;
                case Key.ArrowUp:
                    this._windowRef.instance.prev();
                    break;
                case Key.Enter:
                case Key.Tab:
                    var result = this._windowRef.instance.getActive();
                    this._selectResult(result);
                    break;
                case Key.Escape:
                    this._closePopup();
                    break;
            }
        }
    };
    NgbTypeahead.prototype._openPopup = function () {
        var _this = this;
        if (!this._windowRef) {
            this._windowRef = this._popupService.open();
            this._windowRef.instance.selectEvent.subscribe(function (result) { return _this._selectResult(result); });
        }
    };
    NgbTypeahead.prototype._selectResult = function (result) {
        this.writeValue(result);
        this._onChangeNoEmit(result);
        this._closePopup();
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Function)
    ], NgbTypeahead.prototype, "inputFormatter", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Function)
    ], NgbTypeahead.prototype, "ngbTypeahead", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Function)
    ], NgbTypeahead.prototype, "resultFormatter", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', core_1.TemplateRef)
    ], NgbTypeahead.prototype, "resultTemplate", void 0);
    NgbTypeahead = __decorate([
        core_1.Directive({
            selector: 'input[ngbTypeahead]',
            host: {
                '(blur)': 'onTouched()',
                '[class.open]': '_windowRef !== null',
                '(document:click)': '_closePopup()',
                '(input)': 'onChange($event.target.value)',
                '(keydown)': '_handleKeyDown($event)'
            },
            providers: [NGB_TYPEAHEAD_VALUE_ACCESSOR]
        }), 
        __metadata('design:paramtypes', [core_1.ElementRef, core_1.ViewContainerRef, core_1.Renderer, core_1.Injector, core_1.ComponentFactoryResolver])
    ], NgbTypeahead);
    return NgbTypeahead;
}());
exports.NgbTypeahead = NgbTypeahead;
exports.NGB_TYPEAHEAD_DIRECTIVES = [NgbTypeahead];

//# sourceMappingURL=typeahead.js.map
