"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var util_1 = require('../util/util');
var nextId = 0;
/**
 * This directive should be used to wrap accordion panel titles that need to contain HTML markup or other directives.
 */
var NgbPanelTitle = (function () {
    function NgbPanelTitle(templateRef) {
        this.templateRef = templateRef;
    }
    NgbPanelTitle = __decorate([
        core_1.Directive({ selector: 'template[ngbPanelTitle]' }), 
        __metadata('design:paramtypes', [core_1.TemplateRef])
    ], NgbPanelTitle);
    return NgbPanelTitle;
}());
exports.NgbPanelTitle = NgbPanelTitle;
/**
 * This directive must be used to wrap accordion panel content.
 */
var NgbPanelContent = (function () {
    function NgbPanelContent(templateRef) {
        this.templateRef = templateRef;
    }
    NgbPanelContent = __decorate([
        core_1.Directive({ selector: 'template[ngbPanelContent]' }), 
        __metadata('design:paramtypes', [core_1.TemplateRef])
    ], NgbPanelContent);
    return NgbPanelContent;
}());
exports.NgbPanelContent = NgbPanelContent;
/**
 * The NgbPanel directive represents an in individual panel with the title and collapsible
 * content
 */
var NgbPanel = (function () {
    function NgbPanel() {
        /**
         *  A flag determining whether the panel is disabled or not.
         *  When disabled, the panel cannot be toggled.
         */
        this.disabled = false;
        /**
         *  An optional id for the panel. The id should be unique.
         *  If not provided, it will be auto-generated.
         */
        this.id = "ngb-panel-" + nextId++;
    }
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPanel.prototype, "disabled", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPanel.prototype, "id", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbPanel.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbPanel.prototype, "type", void 0);
    __decorate([
        core_1.ContentChild(NgbPanelContent), 
        __metadata('design:type', NgbPanelContent)
    ], NgbPanel.prototype, "contentTpl", void 0);
    __decorate([
        core_1.ContentChild(NgbPanelTitle), 
        __metadata('design:type', NgbPanelTitle)
    ], NgbPanel.prototype, "titleTpl", void 0);
    NgbPanel = __decorate([
        core_1.Directive({ selector: 'ngb-panel' }), 
        __metadata('design:paramtypes', [])
    ], NgbPanel);
    return NgbPanel;
}());
exports.NgbPanel = NgbPanel;
/**
 * The NgbAccordion directive is a collection of panels.
 * It can assure that only panel can be opened at a time.
 */
var NgbAccordion = (function () {
    function NgbAccordion() {
        /**
         * An array or comma separated strings of panel identifiers that should be opened
         */
        this.activeIds = [];
        /**
         *  Whether the other panels should be closed when a panel is opened
         */
        this.closeOtherPanels = false;
        /**
         * A panel change event fired right before the panel toggle happens. The event object has three properties:
         * 'panelId', the id of panel that id toggled, 'nextState' whether panel will be opened (true) or closed (false),
         * and a function, 'preventDefault()' which, when executed, will prevent the panel toggle from occurring.
         */
        this.change = new core_1.EventEmitter();
        /**
         * A map that stores each panel state
         */
        this._states = new Map();
        /**
         * A map that stores references to all panels
         */
        this._panelRefs = new Map();
    }
    /**
     * Programmatically toggle a panel with a given id.
     */
    NgbAccordion.prototype.toggle = function (panelId) {
        var panel = this._panelRefs.get(panelId);
        if (panel && !panel.disabled) {
            var nextState = !this._states.get(panelId);
            var defaultPrevented_1 = false;
            this.change.emit({ panelId: panelId, nextState: nextState, preventDefault: function () { defaultPrevented_1 = true; } });
            if (!defaultPrevented_1) {
                this._states.set(panelId, nextState);
                if (this.closeOtherPanels) {
                    this._closeOthers(panelId);
                }
                this._updateActiveIds();
            }
        }
    };
    NgbAccordion.prototype.ngAfterContentChecked = function () {
        // active id updates
        if (util_1.isString(this.activeIds)) {
            this.activeIds = this.activeIds.split(/\s*,\s*/);
        }
        this._updateStates();
        // closeOthers updates
        if (this.activeIds.length > 1 && this.closeOtherPanels) {
            this._closeOthers(this.activeIds[0]);
            this._updateActiveIds();
        }
    };
    NgbAccordion.prototype._closeOthers = function (panelId) {
        var _this = this;
        this._states.forEach(function (state, id) {
            if (id !== panelId) {
                _this._states.set(id, false);
            }
        });
    };
    NgbAccordion.prototype._isOpen = function (panelId) { return this._states.get(panelId); };
    NgbAccordion.prototype._updateActiveIds = function () {
        var _this = this;
        this.activeIds =
            this._panels.toArray().filter(function (panel) { return _this._isOpen(panel.id) && !panel.disabled; }).map(function (panel) { return panel.id; });
    };
    NgbAccordion.prototype._updateStates = function () {
        var _this = this;
        this._states.clear();
        this._panelRefs.clear();
        this._panels.toArray().forEach(function (panel) {
            _this._states.set(panel.id, _this.activeIds.indexOf(panel.id) > -1 && !panel.disabled);
            _this._panelRefs.set(panel.id, panel);
        });
    };
    __decorate([
        core_1.ContentChildren(NgbPanel), 
        __metadata('design:type', core_1.QueryList)
    ], NgbAccordion.prototype, "_panels", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbAccordion.prototype, "activeIds", void 0);
    __decorate([
        core_1.Input('closeOthers'), 
        __metadata('design:type', Object)
    ], NgbAccordion.prototype, "closeOtherPanels", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbAccordion.prototype, "type", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbAccordion.prototype, "change", void 0);
    NgbAccordion = __decorate([
        core_1.Component({
            selector: 'ngb-accordion',
            exportAs: 'ngbAccordion',
            template: "\n  <div class=\"card\">\n    <template ngFor let-panel [ngForOf]=\"_panels\">\n      <div [class]=\"'card-header ' + (panel.type ? 'card-'+panel.type: type ? 'card-'+type : '')\" [class.active]=\"_isOpen(panel.id)\">\n        <a tabindex=\"0\" href (click)=\"!!toggle(panel.id)\" [class.text-muted]=\"panel.disabled\">\n          {{panel.title}}<template [ngTemplateOutlet]=\"panel.titleTpl?.templateRef\"></template>          \n        </a>\n      </div>\n      <div class=\"card-block\" *ngIf=\"_isOpen(panel.id)\">\n        <template [ngTemplateOutlet]=\"panel.contentTpl.templateRef\"></template>\n      </div>\n    </template>\n  </div>\n"
        }), 
        __metadata('design:paramtypes', [])
    ], NgbAccordion);
    return NgbAccordion;
}());
exports.NgbAccordion = NgbAccordion;
exports.NGB_ACCORDION_DIRECTIVES = [NgbAccordion, NgbPanel, NgbPanelTitle, NgbPanelContent];

//# sourceMappingURL=accordion.js.map
