"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var popup_1 = require('../util/popup');
/**
 * Alerts can be used to provide feedback messages.
 */
var NgbAlert = (function () {
    function NgbAlert() {
        /**
         * A flag indicating if a given alert can be dismissed (closed) by a user. If this flag is set, a close button (in a
         * form of a cross) will be displayed.
         */
        this.dismissible = true;
        /**
         * Alert type (CSS class). Bootstrap 4 recognizes the following types: "success", "info", "warning" and "danger".
         */
        this.type = 'warning';
        /**
         * An event emitted when the close button is clicked. This event has no payload. Only relevant for dismissible alerts.
         */
        this.close = new core_1.EventEmitter();
    }
    NgbAlert.prototype.closeHandler = function () { this.close.emit(null); };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbAlert.prototype, "dismissible", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbAlert.prototype, "type", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbAlert.prototype, "close", void 0);
    NgbAlert = __decorate([
        core_1.Component({
            selector: 'ngb-alert',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            template: "\n    <div [class]=\"'alert alert-' + type\" role=\"alert\">\n      <button *ngIf=\"dismissible\" type=\"button\" class=\"close\" aria-label=\"Close\" (click)=\"closeHandler()\">\n            <span aria-hidden=\"true\">&times;</span>\n      </button>\n      <ng-content></ng-content>\n    </div>\n    "
        }), 
        __metadata('design:paramtypes', [])
    ], NgbAlert);
    return NgbAlert;
}());
exports.NgbAlert = NgbAlert;
/**
 * Alerts that can be dismissed without any additional code.
 */
var NgbDismissibleAlert = (function () {
    function NgbDismissibleAlert(_templateRef, viewContainerRef, injector, componentFactoryResolver, renderer) {
        this._templateRef = _templateRef;
        /**
         * Alert type (CSS class). Bootstrap 4 recognizes the following types: "success", "info", "warning" and "danger".
         */
        this.type = 'warning';
        /**
         * An event emitted when the close button is clicked.
         */
        this.closeEvent = new core_1.EventEmitter();
        this._popupService =
            new popup_1.PopupService(NgbAlert, injector, viewContainerRef, renderer, componentFactoryResolver);
    }
    NgbDismissibleAlert.prototype.close = function () { this._popupService.close(); };
    NgbDismissibleAlert.prototype.ngOnInit = function () {
        var _this = this;
        this._windowRef = this._popupService.open(this._templateRef);
        this._windowRef.instance.type = this.type;
        this._windowRef.instance.close.subscribe(function ($event) {
            _this.closeEvent.emit($event);
            _this.close();
        });
        if (this.dismissOnTimeout) {
            this._timeout = setTimeout(function () { _this.close(); }, this.dismissOnTimeout);
        }
    };
    NgbDismissibleAlert.prototype.ngOnDestroy = function () { clearTimeout(this._timeout); };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbDismissibleAlert.prototype, "type", void 0);
    __decorate([
        core_1.Output('close'), 
        __metadata('design:type', Object)
    ], NgbDismissibleAlert.prototype, "closeEvent", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], NgbDismissibleAlert.prototype, "dismissOnTimeout", void 0);
    NgbDismissibleAlert = __decorate([
        core_1.Directive({ selector: 'template[ngbAlert]' }), 
        __metadata('design:paramtypes', [core_1.TemplateRef, core_1.ViewContainerRef, core_1.Injector, core_1.ComponentFactoryResolver, core_1.Renderer])
    ], NgbDismissibleAlert);
    return NgbDismissibleAlert;
}());
exports.NgbDismissibleAlert = NgbDismissibleAlert;
exports.NGB_ALERT_DIRECTIVES = [NgbAlert, NgbDismissibleAlert];

//# sourceMappingURL=alert.js.map
