import { EventEmitter } from '@angular/core';
/**
 * Transforms a node into a dropdown.
 */
export declare class NgbDropdown {
    /**
     * Indicates that dropdown should be closed when selecting one of dropdown items (click) or pressing ESC.
     */
    autoClose: boolean;
    /**
     *  Defines whether or not the dropdown-menu is open initially.
     */
    private _open;
    /**
     *  An event fired when the dropdown is opened or closed.
     *  Event's payload equals whether dropdown is open.
     */
    openChange: EventEmitter<{}>;
    /**
     * Checks if the dropdown menu is open or not.
     */
    isOpen(): boolean;
    /**
     * Opens the dropdown menu of a given navbar or tabbed navigation.
     */
    open(): void;
    /**
     * Closes the dropdown menu of a given navbar or tabbed navigation.
     */
    close(): void;
    /**
     * Toggles the dropdown menu of a given navbar or tabbed navigation.
     */
    toggle(): void;
    private _closeFromOutside();
}
/**
 * Allows the dropdown to be toggled via click. This directive is optional.
 */
export declare class NgbDropdownToggle {
    private _dropdown;
    constructor(_dropdown: NgbDropdown);
    toggleOpen($event: any): void;
}
export declare const NGB_DROPDOWN_DIRECTIVES: (typeof NgbDropdownToggle | typeof NgbDropdown)[];
