var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, QueryList, ContentChildren, Directive, TemplateRef, ContentChild, Output, EventEmitter } from '@angular/core';
import { isString } from '../util/util';
let nextId = 0;
/**
 * This directive should be used to wrap accordion panel titles that need to contain HTML markup or other directives.
 */
export let NgbPanelTitle = class NgbPanelTitle {
    constructor(templateRef) {
        this.templateRef = templateRef;
    }
};
NgbPanelTitle = __decorate([
    Directive({ selector: 'template[ngbPanelTitle]' }), 
    __metadata('design:paramtypes', [TemplateRef])
], NgbPanelTitle);
/**
 * This directive must be used to wrap accordion panel content.
 */
export let NgbPanelContent = class NgbPanelContent {
    constructor(templateRef) {
        this.templateRef = templateRef;
    }
};
NgbPanelContent = __decorate([
    Directive({ selector: 'template[ngbPanelContent]' }), 
    __metadata('design:paramtypes', [TemplateRef])
], NgbPanelContent);
/**
 * The NgbPanel directive represents an in individual panel with the title and collapsible
 * content
 */
export let NgbPanel = class NgbPanel {
    constructor() {
        /**
         *  A flag determining whether the panel is disabled or not.
         *  When disabled, the panel cannot be toggled.
         */
        this.disabled = false;
        /**
         *  An optional id for the panel. The id should be unique.
         *  If not provided, it will be auto-generated.
         */
        this.id = `ngb-panel-${nextId++}`;
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPanel.prototype, "disabled", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPanel.prototype, "id", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbPanel.prototype, "title", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbPanel.prototype, "type", void 0);
__decorate([
    ContentChild(NgbPanelContent), 
    __metadata('design:type', NgbPanelContent)
], NgbPanel.prototype, "contentTpl", void 0);
__decorate([
    ContentChild(NgbPanelTitle), 
    __metadata('design:type', NgbPanelTitle)
], NgbPanel.prototype, "titleTpl", void 0);
NgbPanel = __decorate([
    Directive({ selector: 'ngb-panel' }), 
    __metadata('design:paramtypes', [])
], NgbPanel);
/**
 * The NgbAccordion directive is a collection of panels.
 * It can assure that only panel can be opened at a time.
 */
export let NgbAccordion = class NgbAccordion {
    constructor() {
        /**
         * An array or comma separated strings of panel identifiers that should be opened
         */
        this.activeIds = [];
        /**
         *  Whether the other panels should be closed when a panel is opened
         */
        this.closeOtherPanels = false;
        /**
         * A panel change event fired right before the panel toggle happens. The event object has three properties:
         * 'panelId', the id of panel that id toggled, 'nextState' whether panel will be opened (true) or closed (false),
         * and a function, 'preventDefault()' which, when executed, will prevent the panel toggle from occurring.
         */
        this.change = new EventEmitter();
        /**
         * A map that stores each panel state
         */
        this._states = new Map();
        /**
         * A map that stores references to all panels
         */
        this._panelRefs = new Map();
    }
    /**
     * Programmatically toggle a panel with a given id.
     */
    toggle(panelId) {
        const panel = this._panelRefs.get(panelId);
        if (panel && !panel.disabled) {
            const nextState = !this._states.get(panelId);
            let defaultPrevented = false;
            this.change.emit({ panelId: panelId, nextState: nextState, preventDefault: () => { defaultPrevented = true; } });
            if (!defaultPrevented) {
                this._states.set(panelId, nextState);
                if (this.closeOtherPanels) {
                    this._closeOthers(panelId);
                }
                this._updateActiveIds();
            }
        }
    }
    ngAfterContentChecked() {
        // active id updates
        if (isString(this.activeIds)) {
            this.activeIds = this.activeIds.split(/\s*,\s*/);
        }
        this._updateStates();
        // closeOthers updates
        if (this.activeIds.length > 1 && this.closeOtherPanels) {
            this._closeOthers(this.activeIds[0]);
            this._updateActiveIds();
        }
    }
    _closeOthers(panelId) {
        this._states.forEach((state, id) => {
            if (id !== panelId) {
                this._states.set(id, false);
            }
        });
    }
    _isOpen(panelId) { return this._states.get(panelId); }
    _updateActiveIds() {
        this.activeIds =
            this._panels.toArray().filter(panel => this._isOpen(panel.id) && !panel.disabled).map(panel => panel.id);
    }
    _updateStates() {
        this._states.clear();
        this._panelRefs.clear();
        this._panels.toArray().forEach((panel) => {
            this._states.set(panel.id, this.activeIds.indexOf(panel.id) > -1 && !panel.disabled);
            this._panelRefs.set(panel.id, panel);
        });
    }
};
__decorate([
    ContentChildren(NgbPanel), 
    __metadata('design:type', QueryList)
], NgbAccordion.prototype, "_panels", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbAccordion.prototype, "activeIds", void 0);
__decorate([
    Input('closeOthers'), 
    __metadata('design:type', Object)
], NgbAccordion.prototype, "closeOtherPanels", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbAccordion.prototype, "type", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbAccordion.prototype, "change", void 0);
NgbAccordion = __decorate([
    Component({
        selector: 'ngb-accordion',
        exportAs: 'ngbAccordion',
        template: `
  <div class="card">
    <template ngFor let-panel [ngForOf]="_panels">
      <div [class]="'card-header ' + (panel.type ? 'card-'+panel.type: type ? 'card-'+type : '')" [class.active]="_isOpen(panel.id)">
        <a tabindex="0" href (click)="!!toggle(panel.id)" [class.text-muted]="panel.disabled">
          {{panel.title}}<template [ngTemplateOutlet]="panel.titleTpl?.templateRef"></template>          
        </a>
      </div>
      <div class="card-block" *ngIf="_isOpen(panel.id)">
        <template [ngTemplateOutlet]="panel.contentTpl.templateRef"></template>
      </div>
    </template>
  </div>
`
    }), 
    __metadata('design:paramtypes', [])
], NgbAccordion);
export const NGB_ACCORDION_DIRECTIVES = [NgbAccordion, NgbPanel, NgbPanelTitle, NgbPanelContent];

//# sourceMappingURL=accordion.js.map
