var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Directive, TemplateRef, ContentChildren, QueryList, Input } from '@angular/core';
let nextId = 0;
/**
 * Represents an individual slide to be used within a carousel.
 */
export let NgbSlide = class NgbSlide {
    constructor(tplRef) {
        this.tplRef = tplRef;
        /**
         * Unique slide identifier. Must be unique for the entire document for proper accessibility support.
         * Will be auto-generated if not provided.
         */
        this.id = `ngb-slide-${nextId++}`;
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbSlide.prototype, "id", void 0);
NgbSlide = __decorate([
    Directive({ selector: 'template[ngbSlide]' }), 
    __metadata('design:paramtypes', [TemplateRef])
], NgbSlide);
/**
 * Directive to easily create carousels based on Bootstrap's markup.
 */
export let NgbCarousel = class NgbCarousel {
    constructor() {
        /**
         *  Amount of time in milliseconds before next slide is shown.
         */
        this.interval = 5000;
        /**
         *  Whether can wrap from the last to the first slide.
         */
        this.wrap = true;
        /**
         *  A flag for allowing navigation via keyboard
         */
        this.keyboard = true;
    }
    ngAfterContentChecked() {
        let activeSlide = this._getSlideById(this.activeId);
        this.activeId = activeSlide ? activeSlide.id : (this._slides.length ? this._slides.first.id : null);
    }
    ngOnInit() { this._startTimer(); }
    ngOnDestroy() { clearInterval(this._slideChangeInterval); }
    /**
     * Navigate to a slide with a specified identifier.
     */
    select(slideIdx) {
        this._cycleToSelected(slideIdx);
        this._restartTimer();
    }
    /**
     * Navigate to the next slide.
     */
    prev() {
        this._cycleToPrev();
        this._restartTimer();
    }
    /**
     * Navigate to the next slide.
     */
    next() {
        this._cycleToNext();
        this._restartTimer();
    }
    /**
     * Stops the carousel from cycling through items.
     */
    pause() { this._stopTimer(); }
    /**
     * Restarts cycling through the carousel slides from left to right.
     */
    cycle() { this._startTimer(); }
    _keyPrev() {
        if (this.keyboard) {
            this.prev();
        }
    }
    _keyNext() {
        if (this.keyboard) {
            this.next();
        }
    }
    _cycleToNext() {
        let selectedId = this._getNextSlide(this.activeId);
        this._cycleToSelected(selectedId);
    }
    _cycleToPrev() {
        let selectedId = this._getPrevSlide(this.activeId);
        this._cycleToSelected(selectedId);
    }
    _cycleToSelected(slideIdx) {
        let selectedSlide = this._getSlideById(slideIdx);
        if (selectedSlide) {
            this.activeId = selectedSlide.id;
        }
    }
    _restartTimer() {
        this._stopTimer();
        this._startTimer();
    }
    _startTimer() {
        this._slideChangeInterval = setInterval(() => { this._cycleToNext(); }, this.interval);
    }
    _stopTimer() { clearInterval(this._slideChangeInterval); }
    _getSlideById(slideIdx) {
        let slideWithId = this._slides.filter(slide => slide.id === slideIdx);
        return slideWithId.length ? slideWithId[0] : null;
    }
    _getNextSlide(id) {
        let nextSlideId = id;
        let slideArr = this._slides.toArray();
        slideArr.forEach((slide, idx) => {
            if (slide.id === id) {
                let lastSlide = (idx === (slideArr.length - 1));
                nextSlideId =
                    lastSlide ? (this.wrap ? slideArr[0].id : slideArr[slideArr.length - 1].id) : slideArr[idx + 1].id;
            }
        });
        return nextSlideId;
    }
    _getPrevSlide(id) {
        let prevSlideId = id;
        let slideArr = this._slides.toArray();
        slideArr.forEach((slide, idx) => {
            if (slide.id === id) {
                prevSlideId =
                    idx === 0 ? (this.wrap ? slideArr[slideArr.length - 1].id : slideArr[0].id) : slideArr[idx - 1].id;
            }
        });
        return prevSlideId;
    }
};
__decorate([
    ContentChildren(NgbSlide), 
    __metadata('design:type', QueryList)
], NgbCarousel.prototype, "_slides", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbCarousel.prototype, "interval", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbCarousel.prototype, "wrap", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbCarousel.prototype, "keyboard", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbCarousel.prototype, "activeId", void 0);
NgbCarousel = __decorate([
    Component({
        selector: 'ngb-carousel',
        exportAs: 'ngbCarousel',
        host: {
            'class': 'carousel slide',
            '[style.display]': '"block"',
            'tabIndex': '0',
            '(mouseenter)': 'pause()',
            '(mouseleave)': 'cycle()',
            '(keyup.arrowLeft)': '_keyPrev()',
            '(keyup.arrowRight)': '_keyNext()'
        },
        template: `
    <ol class="carousel-indicators">
      <li *ngFor="let slide of _slides" [id]="slide.id" [class.active]="slide.id === activeId" (click)="_cycleToSelected(slide.id)"></li>
    </ol>
    <div class="carousel-inner" role="listbox">
      <div *ngFor="let slide of _slides" class="carousel-item" [class.active]="slide.id === activeId">
        <template [ngTemplateOutlet]="slide.tplRef"></template>
      </div>
    </div>
    <a class="left carousel-control" role="button" (click)="_cycleToPrev()">
      <span class="icon-prev" aria-hidden="true"></span>
      <span class="sr-only">Previous</span>
    </a>
    <a class="right carousel-control" role="button" (click)="_cycleToNext()">
      <span class="icon-next" aria-hidden="true"></span>
      <span class="sr-only">Next</span>
    </a>
    `
    }), 
    __metadata('design:paramtypes', [])
], NgbCarousel);
export const NGB_CAROUSEL_DIRECTIVES = [NgbCarousel, NgbSlide];

//# sourceMappingURL=carousel.js.map
