/**
 * Directive that can be used to provide feedback on the progress of a workflow or an action.
 */
export declare class NgbProgressbar {
    /**
     * Maximal value to be displayed in the progressbar.
     */
    max: number;
    /**
     * A flag indicating if a progress bar should be animated when the value changes. Takes effect only for browsers
     * supporting CSS3 animations.
     */
    animated: boolean;
    /**
     * A flag indicating if a progress bar should be displayed as striped.
     */
    striped: boolean;
    /**
     * Type of progress bar, can be one of "success", "info", "warning" or "danger".
     */
    type: string;
    /**
     * Current value to be displayed in the progressbar. Should be smaller or equal to "max" value.
     */
    value: number;
    getValue(): number;
    getPercentValue(): number;
}
export declare const NGB_PROGRESSBAR_DIRECTIVES: typeof NgbProgressbar[];
