import { ControlValueAccessor } from '@angular/forms';
/**
 * A lightweight & configurable timepicker directive.
 */
export declare class NgbTimepicker implements ControlValueAccessor {
    private model;
    /**
     * Whether to display 12H or 24H mode.
     */
    meridian: boolean;
    /**
     * Whether to display the spinners above and below the inputs.
     */
    spinners: boolean;
    /**
     * Whether to display seconds input.
     */
    seconds: boolean;
    /**
     * Number of hours to increase or decrease when using a button.
     */
    hourStep: number;
    /**
     * Number of minutes to increase or decrease when using a button.
     */
    minuteStep: number;
    /**
     * Number of seconds to increase or decrease when using a button.
     */
    secondStep: number;
    /**
     * To disable timepicker
     */
    disabled: boolean;
    /**
     * To make timepicker readonly
     */
    readonlyInputs: boolean;
    onChange: (_: any) => void;
    onTouched: () => void;
    writeValue(value: any): void;
    registerOnChange(fn: (value: any) => any): void;
    registerOnTouched(fn: () => any): void;
    changeHour(step: number): void;
    changeMinute(step: number): void;
    changeSecond(step: number): void;
    updateHour(newVal: string): void;
    updateMinute(newVal: string): void;
    updateSecond(newVal: string): void;
    toggleMeridian(): void;
    private formatHour(value);
    private formatMinSec(value);
    private propagateModelChange();
}
export declare const NGB_TIMEPICKER_DIRECTIVES: typeof NgbTimepicker[];
