import { EventEmitter, TemplateRef } from '@angular/core';
import { toString } from '../util/util';
export declare type ResultTplCtx = {
    result: any;
    term: string;
    formatter: (_: string) => string;
};
export declare class NgbTypeaheadWindow {
    private _activeIdx;
    /**
     * Typeahead match results to be displayed
     */
    results: any;
    /**
     * Search term used to get current results
     */
    term: string;
    /**
     * A function used to format a given result before display. This function should return a formated string without any
     * HTML markup.
     */
    formatter: typeof toString;
    /**
     * A template to display a matching result.
     */
    resultTemplate: TemplateRef<ResultTplCtx>;
    /**
     * Event raised when users selects a particular result row.
     */
    selectEvent: EventEmitter<{}>;
    getActive(): any;
    markActive(_activeIdx: number): void;
    next(): void;
    prev(): void;
    select(item: any): void;
}
