var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Directive, Input, Output, EventEmitter, ChangeDetectionStrategy, ViewContainerRef, Injector, ComponentFactoryResolver, Renderer, TemplateRef } from '@angular/core';
import { PopupService } from '../util/popup';
/**
 * Alerts can be used to provide feedback messages.
 */
export let NgbAlert = class NgbAlert {
    constructor() {
        /**
         * A flag indicating if a given alert can be dismissed (closed) by a user. If this flag is set, a close button (in a
         * form of a cross) will be displayed.
         */
        this.dismissible = true;
        /**
         * Alert type (CSS class). Bootstrap 4 recognizes the following types: "success", "info", "warning" and "danger".
         */
        this.type = 'warning';
        /**
         * An event emitted when the close button is clicked. This event has no payload. Only relevant for dismissible alerts.
         */
        this.close = new EventEmitter();
    }
    closeHandler() { this.close.emit(null); }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbAlert.prototype, "dismissible", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbAlert.prototype, "type", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbAlert.prototype, "close", void 0);
NgbAlert = __decorate([
    Component({
        selector: 'ngb-alert',
        changeDetection: ChangeDetectionStrategy.OnPush,
        template: `
    <div [class]="'alert alert-' + type" role="alert">
      <button *ngIf="dismissible" type="button" class="close" aria-label="Close" (click)="closeHandler()">
            <span aria-hidden="true">&times;</span>
      </button>
      <ng-content></ng-content>
    </div>
    `
    }), 
    __metadata('design:paramtypes', [])
], NgbAlert);
/**
 * Alerts that can be dismissed without any additional code.
 */
export let NgbDismissibleAlert = class NgbDismissibleAlert {
    constructor(_templateRef, viewContainerRef, injector, componentFactoryResolver, renderer) {
        this._templateRef = _templateRef;
        /**
         * Alert type (CSS class). Bootstrap 4 recognizes the following types: "success", "info", "warning" and "danger".
         */
        this.type = 'warning';
        /**
         * An event emitted when the close button is clicked.
         */
        this.closeEvent = new EventEmitter();
        this._popupService =
            new PopupService(NgbAlert, injector, viewContainerRef, renderer, componentFactoryResolver);
    }
    close() { this._popupService.close(); }
    ngOnInit() {
        this._windowRef = this._popupService.open(this._templateRef);
        this._windowRef.instance.type = this.type;
        this._windowRef.instance.close.subscribe(($event) => {
            this.closeEvent.emit($event);
            this.close();
        });
        if (this.dismissOnTimeout) {
            this._timeout = setTimeout(() => { this.close(); }, this.dismissOnTimeout);
        }
    }
    ngOnDestroy() { clearTimeout(this._timeout); }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbDismissibleAlert.prototype, "type", void 0);
__decorate([
    Output('close'), 
    __metadata('design:type', Object)
], NgbDismissibleAlert.prototype, "closeEvent", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbDismissibleAlert.prototype, "dismissOnTimeout", void 0);
NgbDismissibleAlert = __decorate([
    Directive({ selector: 'template[ngbAlert]' }), 
    __metadata('design:paramtypes', [TemplateRef, ViewContainerRef, Injector, ComponentFactoryResolver, Renderer])
], NgbDismissibleAlert);
export const NGB_ALERT_DIRECTIVES = [NgbAlert, NgbDismissibleAlert];

//# sourceMappingURL=alert.js.map
