var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Directive, Injector, Renderer, TemplateRef, ViewContainerRef, ComponentFactoryResolver } from '@angular/core';
import { isDefined } from '../util/util';
import { NgbModalBackdrop } from './modal-backdrop';
import { NgbModalWindow } from './modal-window';
import { NgbModalStack } from './modal-stack';
import { NgbModalRef } from './modal-ref';
class ModalContentContext {
    close(result) { }
    dismiss(reason) { }
}
export let NgbModalContainer = class NgbModalContainer {
    constructor(_injector, _renderer, _viewContainerRef, componentFactoryResolver, ngbModalStack) {
        this._injector = _injector;
        this._renderer = _renderer;
        this._viewContainerRef = _viewContainerRef;
        this._backdropFactory = componentFactoryResolver.resolveComponentFactory(NgbModalBackdrop);
        this._windowFactory = componentFactoryResolver.resolveComponentFactory(NgbModalWindow);
        ngbModalStack.registerContainer(this);
    }
    open(content, options) {
        const modalContentContext = new ModalContentContext();
        const nodes = this._getContentNodes(content, modalContentContext);
        const windowCmptRef = this._viewContainerRef.createComponent(this._windowFactory, 0, this._injector, nodes);
        let backdropCmptRef;
        let ngbModalRef;
        if (options.backdrop !== false) {
            backdropCmptRef = this._viewContainerRef.createComponent(this._backdropFactory, 0, this._injector);
        }
        ngbModalRef = new NgbModalRef(this._viewContainerRef, windowCmptRef, backdropCmptRef);
        modalContentContext.close = (result) => { ngbModalRef.close(result); };
        modalContentContext.dismiss = (reason) => { ngbModalRef.dismiss(reason); };
        this._applyWindowOptions(windowCmptRef.instance, options);
        return ngbModalRef;
    }
    _applyWindowOptions(windowInstance, options) {
        ['backdrop', 'keyboard', 'size'].forEach((optionName) => {
            if (isDefined(options[optionName])) {
                windowInstance[optionName] = options[optionName];
            }
        });
    }
    _getContentNodes(content, context) {
        if (!content) {
            return [];
        }
        else if (content instanceof TemplateRef) {
            return [this._viewContainerRef.createEmbeddedView(content, context).rootNodes];
        }
        else {
            return [[this._renderer.createText(null, `${content}`)]];
        }
    }
};
NgbModalContainer = __decorate([
    Directive({ selector: 'template[ngbModalContainer]' }), 
    __metadata('design:paramtypes', [Injector, Renderer, ViewContainerRef, ComponentFactoryResolver, NgbModalStack])
], NgbModalContainer);

//# sourceMappingURL=modal-container.js.map
