import { QueryList, TemplateRef, AfterContentChecked, EventEmitter } from '@angular/core';
/**
 * This directive should be used to wrap tab titles that need to contain HTML markup or other directives.
 */
export declare class NgbTabTitle {
    templateRef: TemplateRef<any>;
    constructor(templateRef: TemplateRef<any>);
}
/**
 * This directive must be used to wrap content to be displayed in a tab.
 */
export declare class NgbTabContent {
    templateRef: TemplateRef<any>;
    constructor(templateRef: TemplateRef<any>);
}
/**
 * A directive representing an individual tab.
 */
export declare class NgbTab {
    /**
     * Unique tab identifier. Must be unique for the entire document for proper accessibility support.
     */
    id: string;
    /**
     * Simple (string only) title. Use the "NgbTabTitle" directive for more complex use-cases.
     */
    title: string;
    /**
     * Allows toggling disabled state of a given state. Disabled tabs can't be selected.
     */
    disabled: boolean;
    contentTpl: NgbTabContent;
    titleTpl: NgbTabTitle;
}
/**
 * The payload of the tab change event
 */
export interface NgbTabChangeEvent {
    activeId: string;
    nextId: string;
    preventDefault(): any;
}
/**
 * A component that makes it easy to create tabbed interface.
 */
export declare class NgbTabset implements AfterContentChecked {
    tabs: QueryList<NgbTab>;
    /**
     * An identifier of a tab that should be selected (active).
     */
    activeId: string;
    /**
     * Type of navigation to be used for tabs. Can be one of 'tabs' or 'pills'.
     */
    type: string;
    /**
     * A tab change event fired right before the tab selection happens.  The event object has three properties:
     * 'activeId', the id of the currently active tab, 'nextId' the id of the newly selected tab, and a function,
     * 'preventDefault()' which, when executed, will prevent the tab change from occurring.
     */
    change: EventEmitter<NgbTabChangeEvent>;
    /**
     * Selects the tab with the given id and shows its associated pane.
     * Any other tab that was previously selected becomes unselected and its associated pane is hidden.
     */
    select(tabId: string): void;
    ngAfterContentChecked(): void;
    private _getTabById(id);
}
export declare const NGB_TABSET_DIRECTIVES: (typeof NgbTabset | typeof NgbTab | typeof NgbTabContent)[];
