import { ControlValueAccessor } from '@angular/forms';
import { NgbTime } from './ngb-time';
/**
 * A lightweight & configurable timepicker directive.
 */
export declare class NgbTimepicker implements ControlValueAccessor {
    model: NgbTime;
    /**
     * Whether to display 12H or 24H mode.
     */
    meridian: boolean;
    /**
     * Whether to display the spinners above and below the inputs.
     */
    spinners: boolean;
    /**
     * Whether to display seconds input.
     */
    seconds: boolean;
    /**
     * Number of hours to increase or decrease when using a button.
     */
    hourStep: number;
    /**
     * Number of minutes to increase or decrease when using a button.
     */
    minuteStep: number;
    /**
     * Number of seconds to increase or decrease when using a button.
     */
    secondStep: number;
    /**
     * To disable timepicker
     */
    disabled: boolean;
    /**
     * To make timepicker readonly
     */
    readonlyInputs: boolean;
    onChange: (_: any) => void;
    onTouched: () => void;
    writeValue(value: any): void;
    registerOnChange(fn: (value: any) => any): void;
    registerOnTouched(fn: () => any): void;
    /**
     * @internal
     */
    changeHour(step: number): void;
    /**
     * @internal
     */
    changeMinute(step: number): void;
    /**
     * @internal
     */
    changeSecond(step: number): void;
    /**
     * @internal
     */
    updateHour(newVal: string): void;
    /**
     * @internal
     */
    updateMinute(newVal: string): void;
    /**
     * @internal
     */
    updateSecond(newVal: string): void;
    /**
     * @internal
     */
    toggleMeridian(): void;
    /**
     * @internal
     */
    formatHour(value: number): string;
    /**
     * @internal
     */
    formatMinSec(value: number): string;
    private propagateModelChange();
}
export declare const NGB_TIMEPICKER_DIRECTIVES: typeof NgbTimepicker[];
