var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Directive, Input, ChangeDetectionStrategy, Injector, Renderer, ElementRef, ViewContainerRef, ComponentFactoryResolver } from '@angular/core';
import { listenToTriggers } from '../util/triggers';
import { Positioning } from '../util/positioning';
import { PopupService } from '../util/popup';
export let NgbTooltipWindow = class NgbTooltipWindow {
    constructor() {
        this.placement = 'top';
    }
};
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbTooltipWindow.prototype, "placement", void 0);
NgbTooltipWindow = __decorate([
    Component({
        selector: 'ngb-tooltip-window',
        changeDetection: ChangeDetectionStrategy.OnPush,
        host: { '[class]': '"tooltip in tooltip-" + placement', 'role': 'tooltip' },
        template: `
    <div class="tooltip-arrow"></div>
    <div class="tooltip-inner"><ng-content></ng-content></div>
    `
    }), 
    __metadata('design:paramtypes', [])
], NgbTooltipWindow);
/**
 * A lightweight, extensible directive for fancy tooltip creation.
 */
export let NgbTooltip = class NgbTooltip {
    constructor(_elementRef, _renderer, injector, componentFactoryResolver, viewContainerRef) {
        this._elementRef = _elementRef;
        this._renderer = _renderer;
        /**
         * Placement of a tooltip. Accepts: "top", "bottom", "left", "right"
         */
        this.placement = 'top';
        /**
         * Specifies events that should trigger. Supports a space separated list of event names.
         */
        this.triggers = 'hover';
        this._positioning = new Positioning();
        this._popupService = new PopupService(NgbTooltipWindow, injector, viewContainerRef, _renderer, componentFactoryResolver);
    }
    /**
     * Opens an element’s tooltip. This is considered a “manual” triggering of the tooltip.
     */
    open() {
        if (!this._windowRef) {
            this._windowRef = this._popupService.open(this.ngbTooltip);
            this._windowRef.instance.placement = this.placement;
        }
    }
    /**
     * Closes an element’s tooltip. This is considered a “manual” triggering of the tooltip.
     */
    close() {
        this._popupService.close();
        this._windowRef = null;
    }
    /**
     * Toggles an element’s tooltip. This is considered a “manual” triggering of the tooltip.
     */
    toggle() {
        if (this._windowRef) {
            this.close();
        }
        else {
            this.open();
        }
    }
    ngOnInit() {
        this._unregisterListenersFn = listenToTriggers(this._renderer, this._elementRef.nativeElement, this.triggers, this.open.bind(this), this.close.bind(this), this.toggle.bind(this));
    }
    ngAfterViewChecked() {
        if (this._windowRef) {
            const targetPosition = this._positioning.positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, this.placement, false);
            const targetStyle = this._windowRef.location.nativeElement.style;
            targetStyle.top = `${targetPosition.top}px`;
            targetStyle.left = `${targetPosition.left}px`;
        }
    }
    ngOnDestroy() { this._unregisterListenersFn(); }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTooltip.prototype, "ngbTooltip", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTooltip.prototype, "placement", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTooltip.prototype, "triggers", void 0);
NgbTooltip = __decorate([
    Directive({ selector: '[ngbTooltip]', exportAs: 'ngbTooltip' }), 
    __metadata('design:paramtypes', [ElementRef, Renderer, Injector, ComponentFactoryResolver, ViewContainerRef])
], NgbTooltip);

//# sourceMappingURL=tooltip.js.map
