var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, Output, EventEmitter, TemplateRef } from '@angular/core';
import { toString } from '../util/util';
export let NgbTypeaheadWindow = class NgbTypeaheadWindow {
    constructor() {
        this.activeIdx = 0;
        /**
         * A function used to format a given result before display. This function should return a formatted string without any
         * HTML markup.
         */
        this.formatter = toString;
        /**
         * Event raised when users selects a particular result row.
         */
        this.selectEvent = new EventEmitter();
    }
    getActive() { return this.results[this.activeIdx]; }
    /**
     * @internal
     */
    markActive(activeIdx) { this.activeIdx = activeIdx; }
    next() { this.activeIdx = (this.activeIdx + 1) % this.results.length; }
    prev() { this.activeIdx = (this.activeIdx === 0 ? this.results.length - 1 : this.activeIdx - 1); }
    /**
     * @internal
     */
    select(item) { this.selectEvent.emit(item); }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTypeaheadWindow.prototype, "results", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbTypeaheadWindow.prototype, "term", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTypeaheadWindow.prototype, "formatter", void 0);
__decorate([
    Input(), 
    __metadata('design:type', TemplateRef)
], NgbTypeaheadWindow.prototype, "resultTemplate", void 0);
__decorate([
    Output('select'), 
    __metadata('design:type', Object)
], NgbTypeaheadWindow.prototype, "selectEvent", void 0);
NgbTypeaheadWindow = __decorate([
    Component({
        selector: 'ngb-typeahead-window',
        exportAs: 'ngbTypeaheadWindow',
        host: { 'class': 'dropdown-menu', 'style': 'display: block' },
        template: `
    <template #rt let-result="result" let-term="term" let-formatter="formatter">
      <ngb-highlight [result]="formatter(result)" [term]="term"></ngb-highlight>
    </template>
    <template ngFor [ngForOf]="results" let-result let-idx="index">
      <button class="dropdown-item" [class.active]="idx === activeIdx" 
        (mouseenter)="markActive(idx)" 
        (click)="select(result)">
          <template [ngTemplateOutlet]="resultTemplate || rt" 
          [ngOutletContext]="{result: result, term: term, formatter: formatter}"></template>
      </button>
    </template>
  `
    }), 
    __metadata('design:paramtypes', [])
], NgbTypeaheadWindow);

//# sourceMappingURL=typeahead-window.js.map
