import { TemplateRef } from '@angular/core';
export class PopupService {
    constructor(type, _injector, _viewContainerRef, _renderer, componentFactoryResolver) {
        this._injector = _injector;
        this._viewContainerRef = _viewContainerRef;
        this._renderer = _renderer;
        this._windowFactory = componentFactoryResolver.resolveComponentFactory(type);
    }
    open(content) {
        if (!this._windowRef) {
            const nodes = this._getContentNodes(content);
            this._windowRef = this._viewContainerRef.createComponent(this._windowFactory, 0, this._injector, nodes);
        }
        return this._windowRef;
    }
    close() {
        if (this._windowRef) {
            this._viewContainerRef.remove(this._viewContainerRef.indexOf(this._windowRef.hostView));
            this._windowRef = null;
        }
    }
    _getContentNodes(content) {
        if (!content) {
            return [];
        }
        else if (content instanceof TemplateRef) {
            return [this._viewContainerRef.createEmbeddedView(content).rootNodes];
        }
        else {
            return [[this._renderer.createText(null, `${content}`)]];
        }
    }
}

//# sourceMappingURL=popup.js.map
