"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var modal_dismiss_reasons_1 = require('./modal-dismiss-reasons');
var NgbModalWindow = (function () {
    function NgbModalWindow(_elRef, _renderer) {
        this._elRef = _elRef;
        this._renderer = _renderer;
        this.backdrop = true;
        this.keyboard = true;
        this.dismissEvent = new core_1.EventEmitter();
    }
    NgbModalWindow.prototype.backdropClick = function () {
        if (this.backdrop === true) {
            this.dismiss(modal_dismiss_reasons_1.ModalDismissReasons.BACKDROP_CLICK);
        }
    };
    NgbModalWindow.prototype.escKey = function ($event) {
        if (this.keyboard && !$event.defaultPrevented) {
            this.dismiss(modal_dismiss_reasons_1.ModalDismissReasons.ESC);
        }
    };
    NgbModalWindow.prototype.dismiss = function (reason) { this.dismissEvent.emit(reason); };
    NgbModalWindow.prototype.stopPropagation = function ($event) { $event.stopPropagation(); };
    NgbModalWindow.prototype.ngOnInit = function () {
        this._elWithFocus = document.activeElement;
        this._renderer.setElementClass(document.body, 'modal-open', true);
    };
    NgbModalWindow.prototype.ngAfterViewInit = function () {
        if (!this._isNodeChildOfAnother(this._elRef.nativeElement, document.activeElement)) {
            this._renderer.invokeElementMethod(this._elRef.nativeElement, 'focus', []);
        }
    };
    NgbModalWindow.prototype.ngOnDestroy = function () {
        if (this._elWithFocus && this._isNodeChildOfAnother(document.body, this._elWithFocus)) {
            this._renderer.invokeElementMethod(this._elWithFocus, 'focus', []);
        }
        else {
            this._renderer.invokeElementMethod(document.body, 'focus', []);
        }
        this._elWithFocus = null;
        this._renderer.setElementClass(document.body, 'modal-open', false);
    };
    NgbModalWindow.prototype._isNodeChildOfAnother = function (parentNode, potentialChildNode) { return parentNode.contains(potentialChildNode); };
    __decorate([
        // element that is focused prior to modal opening
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbModalWindow.prototype, "backdrop", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbModalWindow.prototype, "keyboard", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbModalWindow.prototype, "size", void 0);
    __decorate([
        core_1.Output('dismiss'), 
        __metadata('design:type', Object)
    ], NgbModalWindow.prototype, "dismissEvent", void 0);
    NgbModalWindow = __decorate([
        core_1.Component({
            selector: 'ngb-modal-window',
            host: {
                'class': 'modal fade in',
                'role': 'dialog',
                'tabindex': '-1',
                'style': 'display: block;',
                '(keyup.esc)': 'escKey($event)',
                '(click)': 'backdropClick()'
            },
            template: "\n    <div [class]=\"'modal-dialog' + (size ? ' modal-' + size : '')\" role=\"document\">\n        <div class=\"modal-content\" (click)=\"stopPropagation($event)\"><ng-content></ng-content></div>\n    </div>\n    "
        }), 
        __metadata('design:paramtypes', [core_1.ElementRef, core_1.Renderer])
    ], NgbModalWindow);
    return NgbModalWindow;
}());
exports.NgbModalWindow = NgbModalWindow;

//# sourceMappingURL=modal-window.js.map
