"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var util_1 = require('../util/util');
/**
 * A directive that will take care of visualising a pagination bar and enable / disable buttons correctly!
 */
var NgbPagination = (function () {
    function NgbPagination() {
        this._pageCount = 0;
        this.pages = [];
        /**
         *  Whether to show the "First" and "Last" page links
         */
        this.boundaryLinks = false;
        /**
         *  Whether to show the "Next" and "Previous" page links
         */
        this.directionLinks = true;
        /**
         *  Whether to show ellipsis symbols and first/last page numbers when maxSize > number of pages
         */
        this.ellipses = true;
        /**
         *  Whether to rotate pages when maxSize > number of pages.
         *  Current page will be in the middle
         */
        this.rotate = false;
        /**
         *  Maximum number of pages to display.
         */
        this.maxSize = 0;
        /**
         *  Current page.
         */
        this.page = 0;
        /**
         *  Number of items per page.
         */
        this.pageSize = 10;
        /**
         *  An event fired when the page is changed.
         *  Event's payload equals the current page.
         */
        this.pageChange = new core_1.EventEmitter();
    }
    Object.defineProperty(NgbPagination.prototype, "pageCount", {
        get: function () { return this._pageCount; },
        enumerable: true,
        configurable: true
    });
    NgbPagination.prototype.hasPrevious = function () { return this.page > 1; };
    NgbPagination.prototype.hasNext = function () { return this.page < this._pageCount; };
    NgbPagination.prototype.selectPage = function (pageNumber) {
        var prevPageNo = this.page;
        this.page = this._getPageNoInRange(pageNumber);
        if (this.page !== prevPageNo) {
            this.pageChange.emit(this.page);
        }
        this.ngOnChanges();
    };
    NgbPagination.prototype.ngOnChanges = function () {
        // re-calculate new length of pages
        this._pageCount = Math.ceil(this.collectionSize / this.pageSize);
        // fill-in model needed to render pages
        this.pages.length = 0;
        for (var i = 1; i <= this._pageCount; i++) {
            this.pages.push(i);
        }
        // get selected page
        this.page = this._getPageNoInRange(this.page);
        // apply maxSize if necessary
        if (this.maxSize > 0 && this._pageCount > this.maxSize) {
            var start = 0;
            var end = this._pageCount;
            // either paginating or rotating page numbers
            if (this.rotate) {
                _a = this._applyRotation(), start = _a[0], end = _a[1];
            }
            else {
                _b = this._applyPagination(), start = _b[0], end = _b[1];
            }
            this.pages = this.pages.slice(start, end);
            // adding ellipses
            this._applyEllipses(start, end);
        }
        var _a, _b;
    };
    /**
     * @internal
     */
    NgbPagination.prototype.isEllipsis = function (pageNumber) { return pageNumber === -1; };
    /**
     * Appends ellipses and first/last page number to the displayed pages
     */
    NgbPagination.prototype._applyEllipses = function (start, end) {
        if (this.ellipses) {
            if (start > 0) {
                this.pages.unshift(-1);
                this.pages.unshift(1);
            }
            if (end < this._pageCount) {
                this.pages.push(-1);
                this.pages.push(this._pageCount);
            }
        }
    };
    /**
     * Rotates page numbers based on maxSize items visible.
     * Currently selected page stays in the middle:
     *
     * Ex. for selected page = 6:
     * [5,*6*,7] for maxSize = 3
     * [4,5,*6*,7] for maxSize = 4
     */
    NgbPagination.prototype._applyRotation = function () {
        var start = 0;
        var end = this._pageCount;
        var leftOffset = Math.floor(this.maxSize / 2);
        var rightOffset = this.maxSize % 2 === 0 ? leftOffset - 1 : leftOffset;
        if (this.page <= leftOffset) {
            // very beginning, no rotation -> [0..maxSize]
            end = this.maxSize;
        }
        else if (this._pageCount - this.page < leftOffset) {
            // very end, no rotation -> [len-maxSize..len]
            start = this._pageCount - this.maxSize;
        }
        else {
            // rotate
            start = this.page - leftOffset - 1;
            end = this.page + rightOffset;
        }
        return [start, end];
    };
    /**
     * Paginates page numbers based on maxSize items per page
     */
    NgbPagination.prototype._applyPagination = function () {
        var page = Math.ceil(this.page / this.maxSize) - 1;
        var start = page * this.maxSize;
        var end = start + this.maxSize;
        return [start, end];
    };
    NgbPagination.prototype._getPageNoInRange = function (newPageNo) { return util_1.getValueInRange(newPageNo, this._pageCount, 1); };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPagination.prototype, "boundaryLinks", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPagination.prototype, "directionLinks", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPagination.prototype, "ellipses", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPagination.prototype, "rotate", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], NgbPagination.prototype, "collectionSize", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPagination.prototype, "maxSize", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPagination.prototype, "page", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPagination.prototype, "pageSize", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbPagination.prototype, "pageChange", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPagination.prototype, "size", void 0);
    NgbPagination = __decorate([
        core_1.Component({
            selector: 'ngb-pagination',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            template: "\n    <nav>\n      <ul [class]=\"'pagination' + (size ? ' pagination-' + size : '')\">\n        <li *ngIf=\"boundaryLinks\" class=\"page-item\" [class.disabled]=\"!hasPrevious()\">\n          <a aria-label=\"First\" class=\"page-link\" href (click)=\"!!selectPage(1)\">\n            <span aria-hidden=\"true\">&laquo;&laquo;</span>\n            <span class=\"sr-only\">First</span>\n          </a>                \n        </li>\n      \n        <li *ngIf=\"directionLinks\" class=\"page-item\" [class.disabled]=\"!hasPrevious()\">\n          <a aria-label=\"Previous\" class=\"page-link\" href (click)=\"!!selectPage(page-1)\">\n            <span aria-hidden=\"true\">&laquo;</span>\n            <span class=\"sr-only\">Previous</span>\n          </a>\n        </li>\n\n        <li *ngFor=\"let pageNumber of pages\" class=\"page-item\" [class.active]=\"pageNumber === page\" \n          [class.disabled]=\"isEllipsis(pageNumber)\">\n          <a *ngIf=\"isEllipsis(pageNumber)\" class=\"page-link\">...</a>\n          <a *ngIf=\"!isEllipsis(pageNumber)\" class=\"page-link\" href (click)=\"!!selectPage(pageNumber)\">{{pageNumber}}</a>\n        </li>\n\n        <li *ngIf=\"directionLinks\" class=\"page-item\" [class.disabled]=\"!hasNext()\">\n          <a aria-label=\"Next\" class=\"page-link\" href (click)=\"!!selectPage(page+1)\">\n            <span aria-hidden=\"true\">&raquo;</span>\n            <span class=\"sr-only\">Next</span>\n          </a>\n        </li>\n        \n        <li *ngIf=\"boundaryLinks\" class=\"page-item\" [class.disabled]=\"!hasNext()\">\n          <a aria-label=\"Last\" class=\"page-link\" href (click)=\"!!selectPage(pageCount)\">\n            <span aria-hidden=\"true\">&raquo;&raquo;</span>\n            <span class=\"sr-only\">Last</span>\n          </a>                \n        </li>        \n      </ul>\n    </nav>\n  "
        }), 
        __metadata('design:paramtypes', [])
    ], NgbPagination);
    return NgbPagination;
}());
exports.NgbPagination = NgbPagination;
exports.NGB_PAGINATION_DIRECTIVES = [NgbPagination];

//# sourceMappingURL=pagination.js.map
