"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var triggers_1 = require('../util/triggers');
var positioning_1 = require('../util/positioning');
var popup_1 = require('../util/popup');
var NgbPopoverWindow = (function () {
    function NgbPopoverWindow() {
        this.placement = 'top';
    }
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPopoverWindow.prototype, "placement", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbPopoverWindow.prototype, "title", void 0);
    NgbPopoverWindow = __decorate([
        core_1.Component({
            selector: 'ngb-popover-window',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            host: { '[class]': '"popover in popover-" + placement', 'role': 'tooltip' },
            template: "\n    <div class=\"popover-arrow\"></div>\n    <h3 class=\"popover-title\">{{title}}</h3><div class=\"popover-content\"><ng-content></ng-content></div>\n    "
        }), 
        __metadata('design:paramtypes', [])
    ], NgbPopoverWindow);
    return NgbPopoverWindow;
}());
exports.NgbPopoverWindow = NgbPopoverWindow;
/**
 * A lightweight, extensible directive for fancy popover creation.
 */
var NgbPopover = (function () {
    function NgbPopover(_elementRef, _renderer, injector, componentFactoryResolver, viewContainerRef) {
        this._elementRef = _elementRef;
        this._renderer = _renderer;
        /**
         * Placement of a popover. Accepts: "top", "bottom", "left", "right"
         */
        this.placement = 'top';
        /**
         * Specifies events that should trigger. Supports a space separated list of event names.
         */
        this.triggers = 'click';
        this._positioning = new positioning_1.Positioning();
        this._popupService = new popup_1.PopupService(NgbPopoverWindow, injector, viewContainerRef, _renderer, componentFactoryResolver);
    }
    /**
     * Opens an element’s popover. This is considered a “manual” triggering of the popover.
     */
    NgbPopover.prototype.open = function () {
        if (!this._windowRef) {
            this._windowRef = this._popupService.open(this.ngbPopover);
            this._windowRef.instance.placement = this.placement;
            this._windowRef.instance.title = this.title;
        }
    };
    /**
     * Closes an element’s popover. This is considered a “manual” triggering of the popover.
     */
    NgbPopover.prototype.close = function () {
        this._popupService.close();
        this._windowRef = null;
    };
    /**
     * Toggles an element’s popover. This is considered a “manual” triggering of the popover.
     */
    NgbPopover.prototype.toggle = function () {
        if (this._windowRef) {
            this.close();
        }
        else {
            this.open();
        }
    };
    NgbPopover.prototype.ngOnInit = function () {
        this._unregisterListenersFn = triggers_1.listenToTriggers(this._renderer, this._elementRef.nativeElement, this.triggers, this.open.bind(this), this.close.bind(this), this.toggle.bind(this));
    };
    NgbPopover.prototype.ngAfterViewChecked = function () {
        if (this._windowRef) {
            var targetPosition = this._positioning.positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, this.placement, false);
            var targetStyle = this._windowRef.location.nativeElement.style;
            targetStyle.top = targetPosition.top + "px";
            targetStyle.left = targetPosition.left + "px";
        }
    };
    NgbPopover.prototype.ngOnDestroy = function () { this._unregisterListenersFn(); };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPopover.prototype, "ngbPopover", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbPopover.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPopover.prototype, "placement", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPopover.prototype, "triggers", void 0);
    NgbPopover = __decorate([
        core_1.Directive({ selector: '[ngbPopover]', exportAs: 'ngbPopover' }), 
        __metadata('design:paramtypes', [core_1.ElementRef, core_1.Renderer, core_1.Injector, core_1.ComponentFactoryResolver, core_1.ViewContainerRef])
    ], NgbPopover);
    return NgbPopover;
}());
exports.NgbPopover = NgbPopover;
exports.NGB_POPOVER_DIRECTIVES = [NgbPopover, NgbPopoverWindow];

//# sourceMappingURL=popover.js.map
