import { EventEmitter, OnInit } from '@angular/core';
/**
 * Rating directive that will take care of visualising a star rating bar.
 */
export declare class NgbRating implements OnInit {
    private _oldRate;
    range: number[];
    /**
     * Maximal rating that can be given using this widget.
     */
    max: number;
    /**
     * Current rating.
     */
    rate: number;
    /**
     * A flag indicating if rating can be updated.
     */
    readonly: boolean;
    /**
     * An event fired when a user is hovering over a given rating.
     * Event's payload equals to the rating being hovered over.
     */
    hover: EventEmitter<number>;
    /**
     * An event fired when a user stops hovering over a given rating.
     * Event's payload equals to the rating of the last item being hovered over.
     */
    leave: EventEmitter<number>;
    /**
     * An event fired when a user selects a new rating.
     * Event's payload equals to the newly selected rating.
     */
    rateChange: EventEmitter<number>;
    enter(value: number): void;
    ngOnInit(): void;
    reset(): void;
    update(value: number): void;
    private _buildTemplateObjects();
}
export declare const NGB_RATING_DIRECTIVES: typeof NgbRating[];
