"use strict";
var platform_browser_1 = require('@angular/platform-browser');
function normalizeText(txt) {
    return txt.trim().replace(/\s+/g, ' ');
}
function getWindowLinks(element) {
    return Array.from(element.queryAll(platform_browser_1.By.css('button.dropdown-item')));
}
exports.getWindowLinks = getWindowLinks;
function expectResults(nativeEl, resultsDef) {
    var pages = nativeEl.querySelectorAll('button.dropdown-item');
    expect(pages.length).toEqual(resultsDef.length);
    for (var i = 0; i < resultsDef.length; i++) {
        var resultDef = resultsDef[i];
        var classIndicator = resultDef.charAt(0);
        if (classIndicator === '+') {
            expect(pages[i]).toHaveCssClass('active');
            expect(normalizeText(pages[i].textContent)).toEqual(resultDef.substr(1));
        }
        else {
            expect(pages[i]).not.toHaveCssClass('active');
            expect(normalizeText(pages[i].textContent)).toEqual(resultDef);
        }
    }
}
exports.expectResults = expectResults;

//# sourceMappingURL=test-common.js.map
