"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var util_1 = require('../util/util');
var NgbTypeaheadWindow = (function () {
    function NgbTypeaheadWindow() {
        this.activeIdx = 0;
        /**
         * A function used to format a given result before display. This function should return a formatted string without any
         * HTML markup.
         */
        this.formatter = util_1.toString;
        /**
         * Event raised when users selects a particular result row.
         */
        this.selectEvent = new core_1.EventEmitter();
    }
    NgbTypeaheadWindow.prototype.getActive = function () { return this.results[this.activeIdx]; };
    /**
     * @internal
     */
    NgbTypeaheadWindow.prototype.markActive = function (activeIdx) { this.activeIdx = activeIdx; };
    NgbTypeaheadWindow.prototype.next = function () { this.activeIdx = (this.activeIdx + 1) % this.results.length; };
    NgbTypeaheadWindow.prototype.prev = function () { this.activeIdx = (this.activeIdx === 0 ? this.results.length - 1 : this.activeIdx - 1); };
    /**
     * @internal
     */
    NgbTypeaheadWindow.prototype.select = function (item) { this.selectEvent.emit(item); };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTypeaheadWindow.prototype, "results", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbTypeaheadWindow.prototype, "term", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTypeaheadWindow.prototype, "formatter", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', core_1.TemplateRef)
    ], NgbTypeaheadWindow.prototype, "resultTemplate", void 0);
    __decorate([
        core_1.Output('select'), 
        __metadata('design:type', Object)
    ], NgbTypeaheadWindow.prototype, "selectEvent", void 0);
    NgbTypeaheadWindow = __decorate([
        core_1.Component({
            selector: 'ngb-typeahead-window',
            exportAs: 'ngbTypeaheadWindow',
            host: { 'class': 'dropdown-menu', 'style': 'display: block' },
            template: "\n    <template #rt let-result=\"result\" let-term=\"term\" let-formatter=\"formatter\">\n      <ngb-highlight [result]=\"formatter(result)\" [term]=\"term\"></ngb-highlight>\n    </template>\n    <template ngFor [ngForOf]=\"results\" let-result let-idx=\"index\">\n      <button class=\"dropdown-item\" [class.active]=\"idx === activeIdx\" \n        (mouseenter)=\"markActive(idx)\" \n        (click)=\"select(result)\">\n          <template [ngTemplateOutlet]=\"resultTemplate || rt\" \n          [ngOutletContext]=\"{result: result, term: term, formatter: formatter}\"></template>\n      </button>\n    </template>\n  "
        }), 
        __metadata('design:paramtypes', [])
    ], NgbTypeaheadWindow);
    return NgbTypeaheadWindow;
}());
exports.NgbTypeaheadWindow = NgbTypeaheadWindow;

//# sourceMappingURL=typeahead-window.js.map
