"use strict";
var core_1 = require('@angular/core');
var PopupService = (function () {
    function PopupService(type, _injector, _viewContainerRef, _renderer, componentFactoryResolver) {
        this._injector = _injector;
        this._viewContainerRef = _viewContainerRef;
        this._renderer = _renderer;
        this._windowFactory = componentFactoryResolver.resolveComponentFactory(type);
    }
    PopupService.prototype.open = function (content) {
        if (!this._windowRef) {
            var nodes = this._getContentNodes(content);
            this._windowRef = this._viewContainerRef.createComponent(this._windowFactory, 0, this._injector, nodes);
        }
        return this._windowRef;
    };
    PopupService.prototype.close = function () {
        if (this._windowRef) {
            this._viewContainerRef.remove(this._viewContainerRef.indexOf(this._windowRef.hostView));
            this._windowRef = null;
        }
    };
    PopupService.prototype._getContentNodes = function (content) {
        if (!content) {
            return [];
        }
        else if (content instanceof core_1.TemplateRef) {
            return [this._viewContainerRef.createEmbeddedView(content).rootNodes];
        }
        else {
            return [[this._renderer.createText(null, "" + content)]];
        }
    };
    return PopupService;
}());
exports.PopupService = PopupService;

//# sourceMappingURL=popup.js.map
