"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var popup_1 = require('../util/popup');
var alert_config_1 = require('./alert-config');
/**
 * Alerts can be used to provide feedback messages.
 */
var NgbAlert = (function () {
    function NgbAlert(config) {
        /**
         * An event emitted when the close button is clicked. This event has no payload. Only relevant for dismissible alerts.
         */
        this.close = new core_1.EventEmitter();
        this.dismissible = config.dismissible;
        this.type = config.type;
    }
    NgbAlert.prototype.closeHandler = function () { this.close.emit(null); };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], NgbAlert.prototype, "dismissible", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbAlert.prototype, "type", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbAlert.prototype, "close", void 0);
    NgbAlert = __decorate([
        core_1.Component({
            selector: 'ngb-alert',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            template: "\n    <div [class]=\"'alert alert-' + type\" role=\"alert\">\n      <button *ngIf=\"dismissible\" type=\"button\" class=\"close\" aria-label=\"Close\" (click)=\"closeHandler()\">\n            <span aria-hidden=\"true\">&times;</span>\n      </button>\n      <ng-content></ng-content>\n    </div>\n    "
        }), 
        __metadata('design:paramtypes', [alert_config_1.NgbAlertConfig])
    ], NgbAlert);
    return NgbAlert;
}());
exports.NgbAlert = NgbAlert;
/**
 * Alerts that can be dismissed without any additional code.
 */
var NgbSelfClosingAlert = (function () {
    function NgbSelfClosingAlert(_templateRef, viewContainerRef, injector, componentFactoryResolver, renderer, config) {
        this._templateRef = _templateRef;
        /**
         * An event emitted when the close button is clicked.
         */
        this.closeEvent = new core_1.EventEmitter();
        this._popupService =
            new popup_1.PopupService(NgbAlert, injector, viewContainerRef, renderer, componentFactoryResolver);
        this.dismissible = config.dismissible;
        this.type = config.type;
        this.dismissOnTimeout = config.dismissOnTimeout;
    }
    NgbSelfClosingAlert.prototype.close = function () { this._popupService.close(); };
    NgbSelfClosingAlert.prototype.ngOnInit = function () {
        var _this = this;
        var windowRef = this._popupService.open(this._templateRef);
        windowRef.instance.type = this.type;
        windowRef.instance.dismissible = this.dismissible;
        windowRef.instance.close.subscribe(function ($event) {
            _this.closeEvent.emit($event);
            _this.close();
        });
        if (this.dismissOnTimeout) {
            this._timeout = setTimeout(function () { _this.close(); }, this.dismissOnTimeout);
        }
    };
    NgbSelfClosingAlert.prototype.ngOnDestroy = function () { clearTimeout(this._timeout); };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], NgbSelfClosingAlert.prototype, "dismissible", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbSelfClosingAlert.prototype, "type", void 0);
    __decorate([
        core_1.Output('close'), 
        __metadata('design:type', Object)
    ], NgbSelfClosingAlert.prototype, "closeEvent", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], NgbSelfClosingAlert.prototype, "dismissOnTimeout", void 0);
    NgbSelfClosingAlert = __decorate([
        core_1.Directive({ selector: 'template[ngbAlert]' }), 
        __metadata('design:paramtypes', [core_1.TemplateRef, core_1.ViewContainerRef, core_1.Injector, core_1.ComponentFactoryResolver, core_1.Renderer, alert_config_1.NgbSelfClosingAlertConfig])
    ], NgbSelfClosingAlert);
    return NgbSelfClosingAlert;
}());
exports.NgbSelfClosingAlert = NgbSelfClosingAlert;
exports.NGB_ALERT_DIRECTIVES = [NgbAlert, NgbSelfClosingAlert];

//# sourceMappingURL=alert.js.map
