"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var ngb_date_1 = require('./ngb-date');
var datepicker_i18n_1 = require('./datepicker-i18n');
var NgbDatepickerMonthView = (function () {
    function NgbDatepickerMonthView(i18n) {
        this.i18n = i18n;
        this.select = new core_1.EventEmitter();
    }
    NgbDatepickerMonthView.prototype.doSelect = function (day) {
        if (!day.disabled) {
            this.select.emit(ngb_date_1.NgbDate.from(day.date));
        }
    };
    NgbDatepickerMonthView.prototype.isSelected = function (date) { return this.selectedDate && this.selectedDate.equals(date); };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', core_1.TemplateRef)
    ], NgbDatepickerMonthView.prototype, "dayTemplate", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbDatepickerMonthView.prototype, "month", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', ngb_date_1.NgbDate)
    ], NgbDatepickerMonthView.prototype, "selectedDate", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbDatepickerMonthView.prototype, "showWeekdays", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbDatepickerMonthView.prototype, "showWeekNumbers", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbDatepickerMonthView.prototype, "select", void 0);
    NgbDatepickerMonthView = __decorate([
        core_1.Component({
            selector: '[ngbDatepickerMonthView]',
            styles: ["\n    .weekday {\n      padding-bottom: 0.25rem;\n    }\n    .weeknumber {    \n    }\n    .day {\n      padding: 0;\n      height: 100%;\n      cursor: pointer;\n    }\n    .day.disabled {\n      cursor: not-allowed;\n    }\n  "],
            template: "\n    <tr *ngIf=\"showWeekdays\">\n      <td *ngIf=\"showWeekNumbers\"></td>\n      <td *ngFor=\"let w of month.weekdays\" class=\"weekday text-xs-center font-weight-bold\">{{ i18n.getWeekdayName(w) }}</td>\n    </tr>\n    <tr *ngFor=\"let week of month.weeks\">\n      <td *ngIf=\"showWeekNumbers\" class=\"weeknumber small text-xs-center\">{{ week.number }}</td>\n      <td *ngFor=\"let day of week.days\" (click)=\"doSelect(day)\" class=\"day\" [class.disabled]=\"day.disabled\">\n        <template [ngTemplateOutlet]=\"dayTemplate\" \n        [ngOutletContext]=\"{date: {year: day.date.year, month: day.date.month, day: day.date.day}, \n          currentMonth: month.number, \n          disabled: day.disabled, \n          selected: isSelected(day.date)}\">\n        </template>\n      </td>                \n    </tr>\n  "
        }), 
        __metadata('design:paramtypes', [datepicker_i18n_1.NgbDatepickerI18n])
    ], NgbDatepickerMonthView);
    return NgbDatepickerMonthView;
}());
exports.NgbDatepickerMonthView = NgbDatepickerMonthView;

//# sourceMappingURL=datepicker-month-view.js.map
