"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var ngb_date_1 = require('./ngb-date');
var util_1 = require('../util/util');
var datepicker_i18n_1 = require('./datepicker-i18n');
var ngb_calendar_1 = require('./ngb-calendar');
var NgbDatepickerNavigationSelect = (function () {
    function NgbDatepickerNavigationSelect(i18n, calendar) {
        this.i18n = i18n;
        this.years = [];
        this.select = new core_1.EventEmitter();
        this.months = calendar.getMonths();
    }
    NgbDatepickerNavigationSelect.prototype.ngOnChanges = function (changes) {
        if (changes['maxYear'] || changes['minYear']) {
            this._generateYears();
        }
    };
    NgbDatepickerNavigationSelect.prototype.changeMonth = function (month) { this.select.emit(new ngb_date_1.NgbDate(this.date.year, util_1.toInteger(month), 1)); };
    NgbDatepickerNavigationSelect.prototype.changeYear = function (year) { this.select.emit(new ngb_date_1.NgbDate(util_1.toInteger(year), this.date.month, 1)); };
    NgbDatepickerNavigationSelect.prototype._generateYears = function () {
        var _this = this;
        this.years = Array.from({ length: this.maxYear - this.minYear + 1 }, function (e, i) { return _this.minYear + i; });
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', ngb_date_1.NgbDate)
    ], NgbDatepickerNavigationSelect.prototype, "date", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], NgbDatepickerNavigationSelect.prototype, "maxYear", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], NgbDatepickerNavigationSelect.prototype, "minYear", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbDatepickerNavigationSelect.prototype, "select", void 0);
    NgbDatepickerNavigationSelect = __decorate([
        core_1.Component({
            selector: 'ngb-datepicker-navigation-select',
            styles: ["\n    select {\n      /* to align with btn-sm */\n      padding: 0.25rem 0.5rem;\n      font-size: 0.875rem;      \n      line-height: 1.25;\n      width: 50%;\n    }\n  "],
            template: "\n    <select class=\"custom-select d-inline-block\" [value]=\"date.month\" (change)=\"changeMonth($event.target.value)\">\n      <option *ngFor=\"let m of months\" [value]=\"m\">{{ i18n.getMonthName(m) }}</option>\n    </select>" +
                "<select class=\"custom-select d-inline-block\" [value]=\"date.year\" (change)=\"changeYear($event.target.value)\">\n      <option *ngFor=\"let y of years\" [value]=\"y\">{{ y }}</option>\n    </select> \n  " // template needs to be formatted in a certain way so we don't add empty text nodes
        }), 
        __metadata('design:paramtypes', [datepicker_i18n_1.NgbDatepickerI18n, ngb_calendar_1.NgbCalendar])
    ], NgbDatepickerNavigationSelect);
    return NgbDatepickerNavigationSelect;
}());
exports.NgbDatepickerNavigationSelect = NgbDatepickerNavigationSelect;

//# sourceMappingURL=datepicker-navigation-select.js.map
