"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var datepicker_view_model_1 = require('./datepicker-view-model');
var ngb_date_1 = require('./ngb-date');
var datepicker_i18n_1 = require('./datepicker-i18n');
var ngb_calendar_1 = require('./ngb-calendar');
var NgbDatepickerNavigation = (function () {
    function NgbDatepickerNavigation(i18n, _calendar) {
        this.i18n = i18n;
        this._calendar = _calendar;
        this.navigation = datepicker_view_model_1.NavigationEvent;
        this.type = 'select';
        this.navigate = new core_1.EventEmitter();
        this.select = new core_1.EventEmitter();
    }
    NgbDatepickerNavigation.prototype.doNavigate = function (event) { this.navigate.emit(event); };
    NgbDatepickerNavigation.prototype.nextDisabled = function () { return !this.maxDate ? false : this._calendar.getNext(this.date, 'm').after(this.maxDate); };
    NgbDatepickerNavigation.prototype.prevDisabled = function () { return !this.minDate ? false : this._calendar.getPrev(this.date, 'm').before(this.minDate); };
    NgbDatepickerNavigation.prototype.selectDate = function (date) { this.select.emit(date); };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', ngb_date_1.NgbDate)
    ], NgbDatepickerNavigation.prototype, "date", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', ngb_date_1.NgbDate)
    ], NgbDatepickerNavigation.prototype, "maxDate", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', ngb_date_1.NgbDate)
    ], NgbDatepickerNavigation.prototype, "minDate", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], NgbDatepickerNavigation.prototype, "showWeekNumbers", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbDatepickerNavigation.prototype, "type", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbDatepickerNavigation.prototype, "navigate", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbDatepickerNavigation.prototype, "select", void 0);
    NgbDatepickerNavigation = __decorate([
        core_1.Component({
            selector: '[ngbDatepickerNavigation]',
            styles: ["\n    td {\n      text-align: center;\n      padding-bottom: 0.25rem;\n    }\n  "],
            template: "\n    <tr>\n      <td>\n        <button type=\"button\" (click)=\"doNavigate(navigation.PREV)\" class=\"btn btn-sm btn-secondary btn-block\" \n          [disabled]=\"prevDisabled()\">&lt;</button>\n      </td>\n      <td [attr.colspan]=\"showWeekNumbers ? 6 : 5\">      \n        <ngb-datepicker-navigation-select *ngIf=\"type === 'select'\"\n          [date]=\"date\"\n          [minYear]=\"minDate.year\"\n          [maxYear]=\"maxDate.year\"\n          (select)=\"selectDate($event)\">\n        </ngb-datepicker-navigation-select>\n      </td>\n      <td>\n        <button type=\"button\" (click)=\"doNavigate(navigation.NEXT)\" class=\"btn btn-sm btn-secondary btn-block\" \n          [disabled]=\"nextDisabled()\">&gt;</button>\n      </td>\n    </tr>\n  "
        }), 
        __metadata('design:paramtypes', [datepicker_i18n_1.NgbDatepickerI18n, ngb_calendar_1.NgbCalendar])
    ], NgbDatepickerNavigation);
    return NgbDatepickerNavigation;
}());
exports.NgbDatepickerNavigation = NgbDatepickerNavigation;

//# sourceMappingURL=datepicker-navigation.js.map
