"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var forms_1 = require('@angular/forms');
var ngb_calendar_1 = require('./ngb-calendar');
var ngb_date_1 = require('./ngb-date');
var datepicker_service_1 = require('./datepicker-service');
var datepicker_view_model_1 = require('./datepicker-view-model');
var util_1 = require('../util/util');
var datepicker_config_1 = require('./datepicker-config');
var NGB_DATEPICKER_VALUE_ACCESSOR = {
    provide: forms_1.NG_VALUE_ACCESSOR,
    useExisting: core_1.forwardRef(function () { return NgbDatepicker; }),
    multi: true
};
/**
 * A lightweight and highly configurable datepicker directive
 */
var NgbDatepicker = (function () {
    function NgbDatepicker(_service, _calendar, config) {
        this._service = _service;
        this._calendar = _calendar;
        this.onChange = function (_) { };
        this.onTouched = function () { };
        this.dayTemplate = config.dayTemplate;
        this.firstDayOfWeek = config.firstDayOfWeek;
        this.markDisabled = config.markDisabled;
        this.minDate = config.minDate;
        this.maxDate = config.maxDate;
        this.showNavigation = config.showNavigation;
        this.showWeekdays = config.showWeekdays;
        this.showWeekNumbers = config.showWeekNumbers;
        this.startDate = config.startDate;
    }
    /**
     * Navigates current view to provided date. If nothing provided calendar will open current month.
     * Use 'startDate' input as an alternative
     */
    NgbDatepicker.prototype.navigateTo = function (date) {
        this._setViewWithinLimits(date ? ngb_date_1.NgbDate.from(date) : this._calendar.getToday());
        this._updateData();
    };
    NgbDatepicker.prototype.ngOnInit = function () {
        this._setDates();
        this.navigateTo(this.startDate);
    };
    NgbDatepicker.prototype.ngOnChanges = function (changes) {
        this._setDates();
        this.navigateTo(this.startDate);
    };
    /**
     * @internal
     */
    NgbDatepicker.prototype.onDateSelect = function (date) {
        this._setViewWithinLimits(date);
        this.onTouched();
        this.writeValue(date);
        this.onChange({ year: date.year, month: date.month, day: date.day });
        // switch current month
        if (this._date.month !== this.month.number) {
            this._updateData();
        }
    };
    /**
     * @internal
     */
    NgbDatepicker.prototype.onNavigateDateSelect = function (date) {
        this._setViewWithinLimits(date);
        this._updateData();
    };
    /**
     * @internal
     */
    NgbDatepicker.prototype.onNavigateEvent = function (event) {
        switch (event) {
            case datepicker_view_model_1.NavigationEvent.PREV:
                this._setViewWithinLimits(this._calendar.getPrev(this._date, 'm'));
                break;
            case datepicker_view_model_1.NavigationEvent.NEXT:
                this._setViewWithinLimits(this._calendar.getNext(this._date, 'm'));
                break;
        }
        this._updateData();
    };
    /**
     * @internal
     */
    NgbDatepicker.prototype.registerOnChange = function (fn) { this.onChange = fn; };
    /**
     * @internal
     */
    NgbDatepicker.prototype.registerOnTouched = function (fn) { this.onTouched = fn; };
    /**
     * @internal
     */
    NgbDatepicker.prototype.writeValue = function (value) { this.model = value ? new ngb_date_1.NgbDate(value.year, value.month, value.day) : null; };
    NgbDatepicker.prototype._setDates = function () {
        this._maxDate = ngb_date_1.NgbDate.from(this.maxDate);
        this._minDate = ngb_date_1.NgbDate.from(this.minDate);
        this._date = this.startDate ? ngb_date_1.NgbDate.from(this.startDate) : this._calendar.getToday();
        if (!this._minDate) {
            this._minDate = this._calendar.getPrev(this._date, 'y', 10);
        }
        if (!this._maxDate) {
            this._maxDate = this._calendar.getNext(this._date, 'y', 11);
            this._maxDate = this._calendar.getPrev(this._maxDate);
        }
        if (this._minDate && this._maxDate && this._maxDate.before(this._minDate)) {
            throw new Error("'maxDate' " + this._maxDate + " should be greater than 'minDate' " + this._minDate);
        }
    };
    NgbDatepicker.prototype._setViewWithinLimits = function (date) {
        if (this._minDate && date.before(this._minDate)) {
            this._date = new ngb_date_1.NgbDate(this._minDate.year, this._minDate.month, 1);
        }
        else if (this._maxDate && date.after(this._maxDate)) {
            this._date = new ngb_date_1.NgbDate(this._maxDate.year, this._maxDate.month, 1);
        }
        else {
            this._date = new ngb_date_1.NgbDate(date.year, date.month, 1);
        }
    };
    NgbDatepicker.prototype._updateData = function () {
        this.month = this._service.generateMonthViewModel(this._date, this._minDate, this._maxDate, util_1.toInteger(this.firstDayOfWeek), this.markDisabled);
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', core_1.TemplateRef)
    ], NgbDatepicker.prototype, "dayTemplate", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], NgbDatepicker.prototype, "firstDayOfWeek", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Function)
    ], NgbDatepicker.prototype, "markDisabled", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbDatepicker.prototype, "minDate", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbDatepicker.prototype, "maxDate", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], NgbDatepicker.prototype, "showNavigation", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], NgbDatepicker.prototype, "showWeekdays", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], NgbDatepicker.prototype, "showWeekNumbers", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbDatepicker.prototype, "startDate", void 0);
    NgbDatepicker = __decorate([
        core_1.Component({
            exportAs: 'ngbDatepicker',
            selector: 'ngb-datepicker',
            template: "\n    <template #dt let-date=\"date\" let-currentMonth=\"currentMonth\" let-selected=\"selected\" let-disabled=\"disabled\">\n       <div ngbDatepickerDayView [date]=\"date\" [currentMonth]=\"currentMonth\" [selected]=\"selected\" [disabled]=\"disabled\"></div>\n    </template>\n    \n    <table>\n      <tbody *ngIf=\"showNavigation\" ngbDatepickerNavigation\n        [date]=\"_date\"\n        [minDate]=\"_minDate\"\n        [maxDate]=\"_maxDate\"\n        [showWeekNumbers]=\"showWeekNumbers\"\n        (navigate)=\"onNavigateEvent($event)\"\n        (select)=\"onNavigateDateSelect($event)\">\n      </tbody>\n      \n      <tbody ngbDatepickerMonthView\n        [month]=\"month\"\n        [selectedDate]=\"model\"\n        [dayTemplate]=\"dayTemplate || dt\"\n        [showWeekdays]=\"showWeekdays\"\n        [showWeekNumbers]=\"showWeekNumbers\"\n        (select)=\"onDateSelect($event)\">\n      </tbody>\n    </table>\n  ",
            providers: [NGB_DATEPICKER_VALUE_ACCESSOR]
        }), 
        __metadata('design:paramtypes', [datepicker_service_1.NgbDatepickerService, ngb_calendar_1.NgbCalendar, datepicker_config_1.NgbDatepickerConfig])
    ], NgbDatepicker);
    return NgbDatepicker;
}());
exports.NgbDatepicker = NgbDatepicker;

//# sourceMappingURL=datepicker.js.map
