var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Directive, Input, Output, EventEmitter, ChangeDetectionStrategy, ViewContainerRef, Injector, ComponentFactoryResolver, Renderer, TemplateRef } from '@angular/core';
import { PopupService } from '../util/popup';
import { NgbAlertConfig, NgbSelfClosingAlertConfig } from './alert-config';
/**
 * Alerts can be used to provide feedback messages.
 */
export let NgbAlert = class NgbAlert {
    constructor(config) {
        /**
         * An event emitted when the close button is clicked. This event has no payload. Only relevant for dismissible alerts.
         */
        this.close = new EventEmitter();
        this.dismissible = config.dismissible;
        this.type = config.type;
    }
    closeHandler() { this.close.emit(null); }
};
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbAlert.prototype, "dismissible", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbAlert.prototype, "type", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbAlert.prototype, "close", void 0);
NgbAlert = __decorate([
    Component({
        selector: 'ngb-alert',
        changeDetection: ChangeDetectionStrategy.OnPush,
        template: `
    <div [class]="'alert alert-' + type" role="alert">
      <button *ngIf="dismissible" type="button" class="close" aria-label="Close" (click)="closeHandler()">
            <span aria-hidden="true">&times;</span>
      </button>
      <ng-content></ng-content>
    </div>
    `
    }), 
    __metadata('design:paramtypes', [NgbAlertConfig])
], NgbAlert);
/**
 * Alerts that can be dismissed without any additional code.
 */
export let NgbSelfClosingAlert = class NgbSelfClosingAlert {
    constructor(_templateRef, viewContainerRef, injector, componentFactoryResolver, renderer, config) {
        this._templateRef = _templateRef;
        /**
         * An event emitted when the close button is clicked.
         */
        this.closeEvent = new EventEmitter();
        this._popupService =
            new PopupService(NgbAlert, injector, viewContainerRef, renderer, componentFactoryResolver);
        this.dismissible = config.dismissible;
        this.type = config.type;
        this.dismissOnTimeout = config.dismissOnTimeout;
    }
    close() { this._popupService.close(); }
    ngOnInit() {
        const windowRef = this._popupService.open(this._templateRef);
        windowRef.instance.type = this.type;
        windowRef.instance.dismissible = this.dismissible;
        windowRef.instance.close.subscribe(($event) => {
            this.closeEvent.emit($event);
            this.close();
        });
        if (this.dismissOnTimeout) {
            this._timeout = setTimeout(() => { this.close(); }, this.dismissOnTimeout);
        }
    }
    ngOnDestroy() { clearTimeout(this._timeout); }
};
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbSelfClosingAlert.prototype, "dismissible", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbSelfClosingAlert.prototype, "type", void 0);
__decorate([
    Output('close'), 
    __metadata('design:type', Object)
], NgbSelfClosingAlert.prototype, "closeEvent", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbSelfClosingAlert.prototype, "dismissOnTimeout", void 0);
NgbSelfClosingAlert = __decorate([
    Directive({ selector: 'template[ngbAlert]' }), 
    __metadata('design:paramtypes', [TemplateRef, ViewContainerRef, Injector, ComponentFactoryResolver, Renderer, NgbSelfClosingAlertConfig])
], NgbSelfClosingAlert);
export const NGB_ALERT_DIRECTIVES = [NgbAlert, NgbSelfClosingAlert];

//# sourceMappingURL=alert.js.map
