var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Directive, forwardRef, Optional, Input, Renderer, ElementRef } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
const NGB_RADIO_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => NgbRadioGroup),
    multi: true
};
/**
 * Easily create Bootstrap-style radio buttons. A value of a selected button is bound to a variable
 * specified via ngModel.
 */
export let NgbRadioGroup = class NgbRadioGroup {
    constructor() {
        this._radios = new Set();
        this._value = null;
        this.onChange = (_) => { };
        this.onTouched = () => { };
    }
    onRadioChange(radio) {
        this.writeValue(radio.value);
        this.onChange(radio.value);
    }
    onRadioValueUpdate() { this._updateRadios(); }
    register(radio) { this._radios.add(radio); }
    registerOnChange(fn) { this.onChange = fn; }
    registerOnTouched(fn) { this.onTouched = fn; }
    unregister(radio) { this._radios.delete(radio); }
    writeValue(value) {
        this._value = value;
        this._updateRadios();
    }
    _updateRadios() { this._radios.forEach((radio) => radio.markChecked(this._value)); }
};
NgbRadioGroup = __decorate([
    Directive({
        selector: '[ngbRadioGroup]',
        host: { 'data-toggle': 'buttons', 'class': 'btn-group' },
        providers: [NGB_RADIO_VALUE_ACCESSOR]
    }), 
    __metadata('design:paramtypes', [])
], NgbRadioGroup);
export let NgbActiveLabel = class NgbActiveLabel {
    constructor(_renderer, _elRef) {
        this._renderer = _renderer;
        this._elRef = _elRef;
    }
    set active(isActive) { this._renderer.setElementClass(this._elRef.nativeElement, 'active', isActive); }
};
NgbActiveLabel = __decorate([
    Directive({ selector: 'label.btn' }), 
    __metadata('design:paramtypes', [Renderer, ElementRef])
], NgbActiveLabel);
/**
 * Marks an input of type "radio" as part of the NgbRadioGroup.
 */
export let NgbRadio = class NgbRadio {
    constructor(_group, _label, _renderer, _element) {
        this._group = _group;
        this._label = _label;
        this._renderer = _renderer;
        this._element = _element;
        this._value = null;
        if (this._group) {
            this._group.register(this);
        }
    }
    /**
     * You can specify model value of a given radio by binding to the value property.
    */
    set value(value) {
        this._value = value;
        const stringValue = value ? value.toString() : '';
        this._renderer.setElementProperty(this._element.nativeElement, 'value', stringValue);
        if (this._group) {
            this._group.onRadioValueUpdate();
        }
    }
    get value() { return this._value; }
    get isChecked() { return this._checked; }
    markChecked(value) {
        this._checked = (this.value === value && value !== null);
        this._label.active = this._checked;
    }
    ngOnDestroy() {
        if (this._group) {
            this._group.unregister(this);
        }
    }
    onChange() {
        if (this._group) {
            this._group.onRadioChange(this);
        }
    }
};
__decorate([
    Input('value'), 
    __metadata('design:type', Object), 
    __metadata('design:paramtypes', [Object])
], NgbRadio.prototype, "value", null);
NgbRadio = __decorate([
    Directive({ selector: 'input[type=radio]', host: { '(change)': 'onChange($event.target.value)', '[checked]': 'isChecked' } }),
    __param(0, Optional()),
    __param(1, Optional()), 
    __metadata('design:paramtypes', [NgbRadioGroup, NgbActiveLabel, Renderer, ElementRef])
], NgbRadio);
export const NGB_RADIO_DIRECTIVES = [NgbRadio, NgbActiveLabel, NgbRadioGroup];

//# sourceMappingURL=radio.js.map
