var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, TemplateRef, Output, EventEmitter } from '@angular/core';
import { NgbDate } from './ngb-date';
import { NgbDatepickerI18n } from './datepicker-i18n';
export let NgbDatepickerMonthView = class NgbDatepickerMonthView {
    constructor(i18n) {
        this.i18n = i18n;
        this.select = new EventEmitter();
    }
    doSelect(day) {
        if (!day.disabled) {
            this.select.emit(NgbDate.from(day.date));
        }
    }
    isSelected(date) { return this.selectedDate && this.selectedDate.equals(date); }
};
__decorate([
    Input(), 
    __metadata('design:type', TemplateRef)
], NgbDatepickerMonthView.prototype, "dayTemplate", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbDatepickerMonthView.prototype, "month", void 0);
__decorate([
    Input(), 
    __metadata('design:type', NgbDate)
], NgbDatepickerMonthView.prototype, "selectedDate", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbDatepickerMonthView.prototype, "showWeekdays", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbDatepickerMonthView.prototype, "showWeekNumbers", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbDatepickerMonthView.prototype, "select", void 0);
NgbDatepickerMonthView = __decorate([
    Component({
        selector: '[ngbDatepickerMonthView]',
        styles: [`
    .weekday {
      padding-bottom: 0.25rem;
    }
    .weeknumber {    
    }
    .day {
      padding: 0;
      height: 100%;
      cursor: pointer;
    }
    .day.disabled {
      cursor: not-allowed;
    }
  `],
        template: `
    <tr *ngIf="showWeekdays">
      <td *ngIf="showWeekNumbers"></td>
      <td *ngFor="let w of month.weekdays" class="weekday text-xs-center font-weight-bold">{{ i18n.getWeekdayName(w) }}</td>
    </tr>
    <tr *ngFor="let week of month.weeks">
      <td *ngIf="showWeekNumbers" class="weeknumber small text-xs-center">{{ week.number }}</td>
      <td *ngFor="let day of week.days" (click)="doSelect(day)" class="day" [class.disabled]="day.disabled">
        <template [ngTemplateOutlet]="dayTemplate" 
        [ngOutletContext]="{date: {year: day.date.year, month: day.date.month, day: day.date.day}, 
          currentMonth: month.number, 
          disabled: day.disabled, 
          selected: isSelected(day.date)}">
        </template>
      </td>                
    </tr>
  `
    }), 
    __metadata('design:paramtypes', [NgbDatepickerI18n])
], NgbDatepickerMonthView);

//# sourceMappingURL=datepicker-month-view.js.map
