var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, Output, EventEmitter } from '@angular/core';
import { NgbDate } from './ngb-date';
import { toInteger } from '../util/util';
import { NgbDatepickerI18n } from './datepicker-i18n';
import { NgbCalendar } from './ngb-calendar';
export let NgbDatepickerNavigationSelect = class NgbDatepickerNavigationSelect {
    constructor(i18n, calendar) {
        this.i18n = i18n;
        this.years = [];
        this.select = new EventEmitter();
        this.months = calendar.getMonths();
    }
    ngOnChanges(changes) {
        if (changes['maxYear'] || changes['minYear']) {
            this._generateYears();
        }
    }
    changeMonth(month) { this.select.emit(new NgbDate(this.date.year, toInteger(month), 1)); }
    changeYear(year) { this.select.emit(new NgbDate(toInteger(year), this.date.month, 1)); }
    _generateYears() {
        this.years = Array.from({ length: this.maxYear - this.minYear + 1 }, (e, i) => this.minYear + i);
    }
};
__decorate([
    Input(), 
    __metadata('design:type', NgbDate)
], NgbDatepickerNavigationSelect.prototype, "date", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbDatepickerNavigationSelect.prototype, "maxYear", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbDatepickerNavigationSelect.prototype, "minYear", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbDatepickerNavigationSelect.prototype, "select", void 0);
NgbDatepickerNavigationSelect = __decorate([
    Component({
        selector: 'ngb-datepicker-navigation-select',
        styles: [`
    select {
      /* to align with btn-sm */
      padding: 0.25rem 0.5rem;
      font-size: 0.875rem;      
      line-height: 1.25;
      width: 50%;
    }
  `],
        template: `
    <select class="custom-select d-inline-block" [value]="date.month" (change)="changeMonth($event.target.value)">
      <option *ngFor="let m of months" [value]="m">{{ i18n.getMonthName(m) }}</option>
    </select>` +
            `<select class="custom-select d-inline-block" [value]="date.year" (change)="changeYear($event.target.value)">
      <option *ngFor="let y of years" [value]="y">{{ y }}</option>
    </select> 
  ` // template needs to be formatted in a certain way so we don't add empty text nodes
    }), 
    __metadata('design:paramtypes', [NgbDatepickerI18n, NgbCalendar])
], NgbDatepickerNavigationSelect);

//# sourceMappingURL=datepicker-navigation-select.js.map
