var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, Output, EventEmitter } from '@angular/core';
import { NavigationEvent } from './datepicker-view-model';
import { NgbDate } from './ngb-date';
import { NgbDatepickerI18n } from './datepicker-i18n';
import { NgbCalendar } from './ngb-calendar';
export let NgbDatepickerNavigation = class NgbDatepickerNavigation {
    constructor(i18n, _calendar) {
        this.i18n = i18n;
        this._calendar = _calendar;
        this.navigation = NavigationEvent;
        this.type = 'select';
        this.navigate = new EventEmitter();
        this.select = new EventEmitter();
    }
    doNavigate(event) { this.navigate.emit(event); }
    nextDisabled() { return !this.maxDate ? false : this._calendar.getNext(this.date, 'm').after(this.maxDate); }
    prevDisabled() { return !this.minDate ? false : this._calendar.getPrev(this.date, 'm').before(this.minDate); }
    selectDate(date) { this.select.emit(date); }
};
__decorate([
    Input(), 
    __metadata('design:type', NgbDate)
], NgbDatepickerNavigation.prototype, "date", void 0);
__decorate([
    Input(), 
    __metadata('design:type', NgbDate)
], NgbDatepickerNavigation.prototype, "maxDate", void 0);
__decorate([
    Input(), 
    __metadata('design:type', NgbDate)
], NgbDatepickerNavigation.prototype, "minDate", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbDatepickerNavigation.prototype, "showWeekNumbers", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbDatepickerNavigation.prototype, "type", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbDatepickerNavigation.prototype, "navigate", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbDatepickerNavigation.prototype, "select", void 0);
NgbDatepickerNavigation = __decorate([
    Component({
        selector: '[ngbDatepickerNavigation]',
        styles: [`
    td {
      text-align: center;
      padding-bottom: 0.25rem;
    }
  `],
        template: `
    <tr>
      <td>
        <button type="button" (click)="doNavigate(navigation.PREV)" class="btn btn-sm btn-secondary btn-block" 
          [disabled]="prevDisabled()">&lt;</button>
      </td>
      <td [attr.colspan]="showWeekNumbers ? 6 : 5">      
        <ngb-datepicker-navigation-select *ngIf="type === 'select'"
          [date]="date"
          [minYear]="minDate.year"
          [maxYear]="maxDate.year"
          (select)="selectDate($event)">
        </ngb-datepicker-navigation-select>
      </td>
      <td>
        <button type="button" (click)="doNavigate(navigation.NEXT)" class="btn btn-sm btn-secondary btn-block" 
          [disabled]="nextDisabled()">&gt;</button>
      </td>
    </tr>
  `
    }), 
    __metadata('design:paramtypes', [NgbDatepickerI18n, NgbCalendar])
], NgbDatepickerNavigation);

//# sourceMappingURL=datepicker-navigation.js.map
