var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { NgbCalendar } from './ngb-calendar';
import { NgbDate } from './ngb-date';
import { Injectable } from '@angular/core';
export let NgbDatepickerService = class NgbDatepickerService {
    constructor(_calendar) {
        this._calendar = _calendar;
    }
    generateMonthViewModel(date, minDate, maxDate, firstDayOfWeek, markDisabled) {
        const month = { number: date.month, year: date.year, weeks: [], weekdays: [] };
        date = this._getFirstViewDate(date, firstDayOfWeek);
        // month has weeks
        for (let w = 0; w < this._calendar.getWeeksPerMonth(); w++) {
            const days = [];
            // week has days
            for (let d = 0; d < this._calendar.getDaysPerWeek(); d++) {
                if (w === 0) {
                    month.weekdays.push(this._calendar.getWeekday(date));
                }
                const newDate = new NgbDate(date.year, date.month, date.day);
                let disabled = (minDate && newDate.before(minDate)) || (maxDate && newDate.after(maxDate));
                if (!disabled && markDisabled) {
                    disabled = markDisabled(newDate);
                }
                days.push({ date: newDate, disabled: disabled });
                date = this._calendar.getNext(date);
            }
            month.weeks.push({ number: this._calendar.getWeekNumber(days.map(day => NgbDate.from(day.date)), firstDayOfWeek), days: days });
        }
        return month;
    }
    _getFirstViewDate(date, firstDayOfWeek) {
        const currentMonth = date.month;
        let today = new NgbDate(date.year, date.month, date.day);
        let yesterday = this._calendar.getPrev(today);
        const firstDayOfCurrentMonthIsAlsoFirstDayOfWeek = () => { return today.month !== yesterday.month && firstDayOfWeek === this._calendar.getWeekday(today); };
        const reachedTheFirstDayOfTheLastWeekOfPreviousMonth = () => { return today.month !== currentMonth && firstDayOfWeek === this._calendar.getWeekday(today); };
        // going back in time
        while (!reachedTheFirstDayOfTheLastWeekOfPreviousMonth() && !firstDayOfCurrentMonthIsAlsoFirstDayOfWeek()) {
            today = new NgbDate(yesterday.year, yesterday.month, yesterday.day);
            yesterday = this._calendar.getPrev(yesterday);
        }
        return today;
    }
};
NgbDatepickerService = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [NgbCalendar])
], NgbDatepickerService);

//# sourceMappingURL=datepicker-service.js.map
