import { OnChanges, SimpleChanges, TemplateRef, OnInit } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { NgbCalendar } from './ngb-calendar';
import { NgbDate } from './ngb-date';
import { NgbDatepickerService } from './datepicker-service';
import { MonthViewModel, NavigationEvent } from './datepicker-view-model';
import { DayTemplateContext } from './datepicker-day-template-context';
import { NgbDatepickerConfig } from './datepicker-config';
/**
 * A lightweight and highly configurable datepicker directive
 */
export declare class NgbDatepicker implements OnChanges, OnInit, ControlValueAccessor {
    private _service;
    private _calendar;
    _date: NgbDate;
    _maxDate: NgbDate;
    _minDate: NgbDate;
    model: NgbDate;
    month: MonthViewModel;
    /**
     * Reference for the custom template for the day display
     */
    dayTemplate: TemplateRef<DayTemplateContext>;
    /**
     * First day of the week, 0=Sun, 1=Mon, etc.
     */
    firstDayOfWeek: number;
    /**
     * Callback to mark a given date as disabled
     */
    markDisabled: (date: {
        year: number;
        month: number;
        day: number;
    }) => boolean;
    /**
     * Min date for the navigation. If not provided will be 10 years before today or `startDate`
     */
    minDate: {
        year: number;
        month: number;
        day: number;
    };
    /**
     * Max date for the navigation. If not provided will be 10 years from today or `startDate`
     */
    maxDate: {
        year: number;
        month: number;
        day: number;
    };
    /**
     * Whether to display navigation or not
     */
    showNavigation: boolean;
    /**
     * Whether to display days of the week
     */
    showWeekdays: boolean;
    /**
     * Whether to display week numbers
     */
    showWeekNumbers: boolean;
    /**
     * Date to open calendar with. If nothing provided, calendar will open with current month.
     * Use 'navigateTo(date)' as an alternative
     */
    startDate: {
        year: number;
        month: number;
    };
    onChange: (_: any) => void;
    onTouched: () => void;
    constructor(_service: NgbDatepickerService, _calendar: NgbCalendar, config: NgbDatepickerConfig);
    /**
     * Navigates current view to provided date. If nothing provided calendar will open current month.
     * Use 'startDate' input as an alternative
     */
    navigateTo(date?: {
        year: number;
        month: number;
    }): void;
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    /**
     * @internal
     */
    onDateSelect(date: NgbDate): void;
    /**
     * @internal
     */
    onNavigateDateSelect(date: NgbDate): void;
    /**
     * @internal
     */
    onNavigateEvent(event: NavigationEvent): void;
    /**
     * @internal
     */
    registerOnChange(fn: (value: any) => any): void;
    /**
     * @internal
     */
    registerOnTouched(fn: () => any): void;
    /**
     * @internal
     */
    writeValue(value: any): void;
    private _setDates();
    private _setViewWithinLimits(date);
    private _updateData();
}
