var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, TemplateRef, forwardRef } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { NgbCalendar } from './ngb-calendar';
import { NgbDate } from './ngb-date';
import { NgbDatepickerService } from './datepicker-service';
import { NavigationEvent } from './datepicker-view-model';
import { toInteger } from '../util/util';
import { NgbDatepickerConfig } from './datepicker-config';
const NGB_DATEPICKER_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => NgbDatepicker),
    multi: true
};
/**
 * A lightweight and highly configurable datepicker directive
 */
export let NgbDatepicker = class NgbDatepicker {
    constructor(_service, _calendar, config) {
        this._service = _service;
        this._calendar = _calendar;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.dayTemplate = config.dayTemplate;
        this.firstDayOfWeek = config.firstDayOfWeek;
        this.markDisabled = config.markDisabled;
        this.minDate = config.minDate;
        this.maxDate = config.maxDate;
        this.showNavigation = config.showNavigation;
        this.showWeekdays = config.showWeekdays;
        this.showWeekNumbers = config.showWeekNumbers;
        this.startDate = config.startDate;
    }
    /**
     * Navigates current view to provided date. If nothing provided calendar will open current month.
     * Use 'startDate' input as an alternative
     */
    navigateTo(date) {
        this._setViewWithinLimits(date ? NgbDate.from(date) : this._calendar.getToday());
        this._updateData();
    }
    ngOnInit() {
        this._setDates();
        this.navigateTo(this.startDate);
    }
    ngOnChanges(changes) {
        this._setDates();
        this.navigateTo(this.startDate);
    }
    /**
     * @internal
     */
    onDateSelect(date) {
        this._setViewWithinLimits(date);
        this.onTouched();
        this.writeValue(date);
        this.onChange({ year: date.year, month: date.month, day: date.day });
        // switch current month
        if (this._date.month !== this.month.number) {
            this._updateData();
        }
    }
    /**
     * @internal
     */
    onNavigateDateSelect(date) {
        this._setViewWithinLimits(date);
        this._updateData();
    }
    /**
     * @internal
     */
    onNavigateEvent(event) {
        switch (event) {
            case NavigationEvent.PREV:
                this._setViewWithinLimits(this._calendar.getPrev(this._date, 'm'));
                break;
            case NavigationEvent.NEXT:
                this._setViewWithinLimits(this._calendar.getNext(this._date, 'm'));
                break;
        }
        this._updateData();
    }
    /**
     * @internal
     */
    registerOnChange(fn) { this.onChange = fn; }
    /**
     * @internal
     */
    registerOnTouched(fn) { this.onTouched = fn; }
    /**
     * @internal
     */
    writeValue(value) { this.model = value ? new NgbDate(value.year, value.month, value.day) : null; }
    _setDates() {
        this._maxDate = NgbDate.from(this.maxDate);
        this._minDate = NgbDate.from(this.minDate);
        this._date = this.startDate ? NgbDate.from(this.startDate) : this._calendar.getToday();
        if (!this._minDate) {
            this._minDate = this._calendar.getPrev(this._date, 'y', 10);
        }
        if (!this._maxDate) {
            this._maxDate = this._calendar.getNext(this._date, 'y', 11);
            this._maxDate = this._calendar.getPrev(this._maxDate);
        }
        if (this._minDate && this._maxDate && this._maxDate.before(this._minDate)) {
            throw new Error(`'maxDate' ${this._maxDate} should be greater than 'minDate' ${this._minDate}`);
        }
    }
    _setViewWithinLimits(date) {
        if (this._minDate && date.before(this._minDate)) {
            this._date = new NgbDate(this._minDate.year, this._minDate.month, 1);
        }
        else if (this._maxDate && date.after(this._maxDate)) {
            this._date = new NgbDate(this._maxDate.year, this._maxDate.month, 1);
        }
        else {
            this._date = new NgbDate(date.year, date.month, 1);
        }
    }
    _updateData() {
        this.month = this._service.generateMonthViewModel(this._date, this._minDate, this._maxDate, toInteger(this.firstDayOfWeek), this.markDisabled);
    }
};
__decorate([
    Input(), 
    __metadata('design:type', TemplateRef)
], NgbDatepicker.prototype, "dayTemplate", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbDatepicker.prototype, "firstDayOfWeek", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Function)
], NgbDatepicker.prototype, "markDisabled", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbDatepicker.prototype, "minDate", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbDatepicker.prototype, "maxDate", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbDatepicker.prototype, "showNavigation", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbDatepicker.prototype, "showWeekdays", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbDatepicker.prototype, "showWeekNumbers", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbDatepicker.prototype, "startDate", void 0);
NgbDatepicker = __decorate([
    Component({
        exportAs: 'ngbDatepicker',
        selector: 'ngb-datepicker',
        template: `
    <template #dt let-date="date" let-currentMonth="currentMonth" let-selected="selected" let-disabled="disabled">
       <div ngbDatepickerDayView [date]="date" [currentMonth]="currentMonth" [selected]="selected" [disabled]="disabled"></div>
    </template>
    
    <table>
      <tbody *ngIf="showNavigation" ngbDatepickerNavigation
        [date]="_date"
        [minDate]="_minDate"
        [maxDate]="_maxDate"
        [showWeekNumbers]="showWeekNumbers"
        (navigate)="onNavigateEvent($event)"
        (select)="onNavigateDateSelect($event)">
      </tbody>
      
      <tbody ngbDatepickerMonthView
        [month]="month"
        [selectedDate]="model"
        [dayTemplate]="dayTemplate || dt"
        [showWeekdays]="showWeekdays"
        [showWeekNumbers]="showWeekNumbers"
        (select)="onDateSelect($event)">
      </tbody>
    </table>
  `,
        providers: [NGB_DATEPICKER_VALUE_ACCESSOR]
    }), 
    __metadata('design:paramtypes', [NgbDatepickerService, NgbCalendar, NgbDatepickerConfig])
], NgbDatepicker);

//# sourceMappingURL=datepicker.js.map
