export class NgbDate {
    constructor(year, month, day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }
    static from(date) {
        return date ? new NgbDate(date.year, date.month, date.day ? date.day : 1) : null;
    }
    equals(other) {
        return other && this.year === other.year && this.month === other.month && this.day === other.day;
    }
    before(other) {
        if (!other) {
            return false;
        }
        if (this.year === other.year) {
            if (this.month === other.month) {
                return this.day === other.day ? false : this.day < other.day;
            }
            else {
                return this.month < other.month;
            }
        }
        else {
            return this.year < other.year;
        }
    }
    after(other) {
        if (!other) {
            return false;
        }
        if (this.year === other.year) {
            if (this.month === other.month) {
                return this.day === other.day ? false : this.day > other.day;
            }
            else {
                return this.month > other.month;
            }
        }
        else {
            return this.year > other.year;
        }
    }
    toString() { return `${this.year}-${this.month}-${this.day}`; }
}

//# sourceMappingURL=ngb-date.js.map
