var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Output, EventEmitter, Input, ElementRef, Renderer } from '@angular/core';
import { ModalDismissReasons } from './modal-dismiss-reasons';
export let NgbModalWindow = class NgbModalWindow {
    constructor(_elRef, _renderer) {
        this._elRef = _elRef;
        this._renderer = _renderer;
        this.backdrop = true;
        this.keyboard = true;
        this.dismissEvent = new EventEmitter();
    }
    backdropClick() {
        if (this.backdrop === true) {
            this.dismiss(ModalDismissReasons.BACKDROP_CLICK);
        }
    }
    escKey($event) {
        if (this.keyboard && !$event.defaultPrevented) {
            this.dismiss(ModalDismissReasons.ESC);
        }
    }
    dismiss(reason) { this.dismissEvent.emit(reason); }
    stopPropagation($event) { $event.stopPropagation(); }
    ngOnInit() {
        this._elWithFocus = document.activeElement;
        this._renderer.setElementClass(document.body, 'modal-open', true);
    }
    ngAfterViewInit() {
        if (!this._isNodeChildOfAnother(this._elRef.nativeElement, document.activeElement)) {
            this._renderer.invokeElementMethod(this._elRef.nativeElement, 'focus', []);
        }
    }
    ngOnDestroy() {
        if (this._elWithFocus && this._isNodeChildOfAnother(document.body, this._elWithFocus)) {
            this._renderer.invokeElementMethod(this._elWithFocus, 'focus', []);
        }
        else {
            this._renderer.invokeElementMethod(document.body, 'focus', []);
        }
        this._elWithFocus = null;
        this._renderer.setElementClass(document.body, 'modal-open', false);
    }
    _isNodeChildOfAnother(parentNode, potentialChildNode) { return parentNode.contains(potentialChildNode); }
};
__decorate([
    // element that is focused prior to modal opening
    Input(), 
    __metadata('design:type', Object)
], NgbModalWindow.prototype, "backdrop", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbModalWindow.prototype, "keyboard", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbModalWindow.prototype, "size", void 0);
__decorate([
    Output('dismiss'), 
    __metadata('design:type', Object)
], NgbModalWindow.prototype, "dismissEvent", void 0);
NgbModalWindow = __decorate([
    Component({
        selector: 'ngb-modal-window',
        host: {
            'class': 'modal fade in',
            'role': 'dialog',
            'tabindex': '-1',
            'style': 'display: block;',
            '(keyup.esc)': 'escKey($event)',
            '(click)': 'backdropClick()'
        },
        template: `
    <div [class]="'modal-dialog' + (size ? ' modal-' + size : '')" role="document">
        <div class="modal-content" (click)="stopPropagation($event)"><ng-content></ng-content></div>
    </div>
    `
    }), 
    __metadata('design:paramtypes', [ElementRef, Renderer])
], NgbModalWindow);

//# sourceMappingURL=modal-window.js.map
