var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Directive, Input, ChangeDetectionStrategy, Injector, Renderer, ElementRef, ViewContainerRef, ComponentFactoryResolver } from '@angular/core';
import { listenToTriggers } from '../util/triggers';
import { Positioning } from '../util/positioning';
import { PopupService } from '../util/popup';
import { NgbPopoverConfig } from './popover-config';
export let NgbPopoverWindow = class NgbPopoverWindow {
    constructor() {
        this.placement = 'top';
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPopoverWindow.prototype, "placement", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbPopoverWindow.prototype, "title", void 0);
NgbPopoverWindow = __decorate([
    Component({
        selector: 'ngb-popover-window',
        changeDetection: ChangeDetectionStrategy.OnPush,
        host: { '[class]': '"popover in popover-" + placement', 'role': 'tooltip' },
        template: `
    <div class="popover-arrow"></div>
    <h3 class="popover-title">{{title}}</h3><div class="popover-content"><ng-content></ng-content></div>
    `
    }), 
    __metadata('design:paramtypes', [])
], NgbPopoverWindow);
/**
 * A lightweight, extensible directive for fancy popover creation.
 */
export let NgbPopover = class NgbPopover {
    constructor(_elementRef, _renderer, injector, componentFactoryResolver, viewContainerRef, config) {
        this._elementRef = _elementRef;
        this._renderer = _renderer;
        this._positioning = new Positioning();
        this.placement = config.placement;
        this.triggers = config.triggers;
        this._popupService = new PopupService(NgbPopoverWindow, injector, viewContainerRef, _renderer, componentFactoryResolver);
    }
    /**
     * Opens an element’s popover. This is considered a “manual” triggering of the popover.
     */
    open() {
        if (!this._windowRef) {
            this._windowRef = this._popupService.open(this.ngbPopover);
            this._windowRef.instance.placement = this.placement;
            this._windowRef.instance.title = this.title;
        }
    }
    /**
     * Closes an element’s popover. This is considered a “manual” triggering of the popover.
     */
    close() {
        this._popupService.close();
        this._windowRef = null;
    }
    /**
     * Toggles an element’s popover. This is considered a “manual” triggering of the popover.
     */
    toggle() {
        if (this._windowRef) {
            this.close();
        }
        else {
            this.open();
        }
    }
    ngOnInit() {
        this._unregisterListenersFn = listenToTriggers(this._renderer, this._elementRef.nativeElement, this.triggers, this.open.bind(this), this.close.bind(this), this.toggle.bind(this));
    }
    ngAfterViewChecked() {
        if (this._windowRef) {
            const targetPosition = this._positioning.positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, this.placement, false);
            const targetStyle = this._windowRef.location.nativeElement.style;
            targetStyle.top = `${targetPosition.top}px`;
            targetStyle.left = `${targetPosition.left}px`;
        }
    }
    ngOnDestroy() { this._unregisterListenersFn(); }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPopover.prototype, "ngbPopover", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbPopover.prototype, "title", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPopover.prototype, "placement", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbPopover.prototype, "triggers", void 0);
NgbPopover = __decorate([
    Directive({ selector: '[ngbPopover]', exportAs: 'ngbPopover' }), 
    __metadata('design:paramtypes', [ElementRef, Renderer, Injector, ComponentFactoryResolver, ViewContainerRef, NgbPopoverConfig])
], NgbPopover);
export const NGB_POPOVER_DIRECTIVES = [NgbPopover, NgbPopoverWindow];

//# sourceMappingURL=popover.js.map
