var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { getValueInRange } from '../util/util';
import { NgbProgressbarConfig } from './progressbar-config';
/**
 * Directive that can be used to provide feedback on the progress of a workflow or an action.
 */
export let NgbProgressbar = class NgbProgressbar {
    constructor(config) {
        /**
         * Current value to be displayed in the progressbar. Should be smaller or equal to "max" value.
         */
        this.value = 0;
        this.max = config.max;
        this.animated = config.animated;
        this.striped = config.striped;
        this.type = config.type;
    }
    getValue() { return getValueInRange(this.value, this.max); }
    getPercentValue() { return 100 * this.getValue() / this.max; }
};
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbProgressbar.prototype, "max", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbProgressbar.prototype, "animated", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbProgressbar.prototype, "striped", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbProgressbar.prototype, "type", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbProgressbar.prototype, "value", void 0);
NgbProgressbar = __decorate([
    Component({
        selector: 'ngb-progressbar',
        changeDetection: ChangeDetectionStrategy.OnPush,
        template: `
    <progress class="progress {{type ? 'progress-' + type : ''}}" 
      [class.progress-animated]="animated" 
      [class.progress-striped]="striped"
      [max]="max" [value]="getValue()">
      <div class="progress">
        <span class="progress-bar" [style.width.%]="getPercentValue()"><ng-content></ng-content></span>
      </div>
    </progress>
  `
    }), 
    __metadata('design:paramtypes', [NgbProgressbarConfig])
], NgbProgressbar);
export const NGB_PROGRESSBAR_DIRECTIVES = [NgbProgressbar];

//# sourceMappingURL=progressbar.js.map
