var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, forwardRef } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { isNumber, padNumber, toInteger } from '../util/util';
import { NgbTime } from './ngb-time';
import { NgbTimepickerConfig } from './timepicker-config';
const NGB_TIMEPICKER_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => NgbTimepicker),
    multi: true
};
/**
 * A lightweight & configurable timepicker directive.
 */
export let NgbTimepicker = class NgbTimepicker {
    constructor(config) {
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.meridian = config.meridian;
        this.spinners = config.spinners;
        this.seconds = config.seconds;
        this.hourStep = config.hourStep;
        this.minuteStep = config.minuteStep;
        this.secondStep = config.secondStep;
        this.disabled = config.disabled;
        this.readonlyInputs = config.readonlyInputs;
    }
    writeValue(value) { this.model = value ? new NgbTime(value.hour, value.minute, value.second) : new NgbTime(); }
    registerOnChange(fn) { this.onChange = fn; }
    registerOnTouched(fn) { this.onTouched = fn; }
    /**
     * @internal
     */
    changeHour(step) {
        this.model.changeHour(step);
        this.propagateModelChange();
    }
    /**
     * @internal
     */
    changeMinute(step) {
        this.model.changeMinute(step);
        this.propagateModelChange();
    }
    /**
     * @internal
     */
    changeSecond(step) {
        this.model.changeSecond(step);
        this.propagateModelChange();
    }
    /**
     * @internal
     */
    updateHour(newVal) {
        this.model.updateHour(toInteger(newVal));
        this.propagateModelChange();
    }
    /**
     * @internal
     */
    updateMinute(newVal) {
        this.model.updateMinute(toInteger(newVal));
        this.propagateModelChange();
    }
    /**
     * @internal
     */
    updateSecond(newVal) {
        this.model.updateSecond(toInteger(newVal));
        this.propagateModelChange();
    }
    /**
     * @internal
     */
    toggleMeridian() {
        if (this.meridian) {
            this.changeHour(12);
        }
    }
    /**
     * @internal
     */
    formatHour(value) { return padNumber(isNumber(value) ? (value % (this.meridian ? 12 : 24)) : NaN); }
    /**
     * @internal
     */
    formatMinSec(value) { return padNumber(value); }
    propagateModelChange() {
        this.onTouched();
        if (this.model.isValid(this.seconds)) {
            this.onChange({ hour: this.model.hour, minute: this.model.minute, second: this.model.second });
        }
        else {
            this.onChange(null);
        }
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbTimepicker.prototype, "meridian", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbTimepicker.prototype, "spinners", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbTimepicker.prototype, "seconds", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbTimepicker.prototype, "hourStep", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbTimepicker.prototype, "minuteStep", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbTimepicker.prototype, "secondStep", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbTimepicker.prototype, "disabled", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbTimepicker.prototype, "readonlyInputs", void 0);
NgbTimepicker = __decorate([
    Component({
        selector: 'ngb-timepicker',
        styles: [`
    .chevron::before {
      border-style: solid;
      border-width: 0.29em 0.29em 0 0;
      content: '';
      display: inline-block;
      height: 0.69em;
      left: 0.05em;
      position: relative;
      top: 0.15em;
      transform: rotate(-45deg);
      vertical-align: middle;
      width: 0.71em;
    }
    
    .chevron.bottom:before {
      top: -.3em;
      transform: rotate(135deg);
    }
    
    .btn-link {
      outline: 0;
    }

    .btn-link.disabled {
      cursor: not-allowed;
      opacity: .65;
    }
  `],
        template: `
     <fieldset [disabled]="disabled" [class.disabled]="disabled">
      <table>
        <tr *ngIf="spinners">
          <td class="text-xs-center">
            <button type="button" class="btn-link" (click)="changeHour(hourStep)"
              [disabled]="disabled" [class.disabled]="disabled">
              <span class="chevron"></span>
            </button>
          </td>
          <td>&nbsp;</td>
          <td class="text-xs-center">
            <button type="button" class="btn-link" (click)="changeMinute(minuteStep)"
              [disabled]="disabled" [class.disabled]="disabled">
                <span class="chevron"></span>
            </button>
          </td>
          <template [ngIf]="seconds">
            <td>&nbsp;</td>
            <td class="text-xs-center">
              <button type="button" class="btn-link" (click)="changeSecond(secondStep)"
                [disabled]="disabled" [class.disabled]="disabled">
                <span class="chevron"></span>
              </button>
            </td>
          </template>
          <template [ngIf]="meridian">
            <td>&nbsp;</td>
            <td>&nbsp;</td>
          </template>
        </tr>
        <tr>
          <td>
            <input type="text" class="form-control" maxlength="2" size="2" placeholder="HH"
              [value]="formatHour(model?.hour)" (change)="updateHour($event.target.value)" 
              [readonly]="readonlyInputs" [disabled]="disabled">
          </td>
          <td>&nbsp;:&nbsp;</td>
          <td>
            <input type="text" class="form-control" maxlength="2" size="2" placeholder="MM"
              [value]="formatMinSec(model?.minute)" (change)="updateMinute($event.target.value)" 
              [readonly]="readonlyInputs" [disabled]="disabled">
          </td>
          <template [ngIf]="seconds">
            <td>&nbsp;:&nbsp;</td>
            <input type="text" class="form-control" maxlength="2" size="2" placeholder="SS"
              [value]="formatMinSec(model?.second)" (change)="updateSecond($event.target.value)" 
              [readonly]="readonlyInputs" [disabled]="disabled">
          </template>
          <template [ngIf]="meridian">
            <td>&nbsp;&nbsp;</td>
            <td>
              <button type="button" class="btn btn-outline-primary" (click)="toggleMeridian()">{{model.hour > 12 ? 'PM' : 'AM'}}</button>
            </td>
          </template>
        </tr>
        <tr *ngIf="spinners">
          <td class="text-xs-center">
            <button type="button" class="btn-link" (click)="changeHour(-hourStep)" 
              [disabled]="disabled" [class.disabled]="disabled">
              <span class="chevron bottom"></span>
            </button>
          </td>
          <td>&nbsp;</td>
          <td class="text-xs-center">
            <button type="button" class="btn-link" (click)="changeMinute(-minuteStep)"
              [disabled]="disabled" [class.disabled]="disabled">
              <span class="chevron bottom"></span>
            </button>
          </td>
          <template [ngIf]="seconds">
            <td>&nbsp;</td>
            <td class="text-xs-center">
              <button type="button" class="btn-link" (click)="changeSecond(-secondStep)"
                [disabled]="disabled" [class.disabled]="disabled">
                <span class="chevron bottom"></span>
              </button>
            </td>
          </template>
          <template [ngIf]="meridian">
            <td>&nbsp;</td>
            <td>&nbsp;</td>
          </template>
        </tr>
      </table>
    </fieldset>
  `,
        providers: [NGB_TIMEPICKER_VALUE_ACCESSOR]
    }), 
    __metadata('design:paramtypes', [NgbTimepickerConfig])
], NgbTimepicker);
export const NGB_TIMEPICKER_DIRECTIVES = [NgbTimepicker];

//# sourceMappingURL=timepicker.js.map
