var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { regExpEscape, toString } from '../util/util';
export let NgbHighlight = class NgbHighlight {
    constructor() {
        this.highlightClass = 'ngb-highlight';
    }
    ngOnChanges() {
        const resultStr = toString(this.result);
        const resultLC = resultStr.toLowerCase();
        const termLC = toString(this.term).toLowerCase();
        let currentIdx = 0;
        if (termLC.length > 0) {
            this.parts = resultLC.split(new RegExp(`(${regExpEscape(termLC)})`)).map((part) => {
                const originalPart = resultStr.substr(currentIdx, part.length);
                currentIdx += part.length;
                return originalPart;
            });
        }
        else {
            this.parts = [resultStr];
        }
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbHighlight.prototype, "highlightClass", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbHighlight.prototype, "result", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbHighlight.prototype, "term", void 0);
NgbHighlight = __decorate([
    Component({
        selector: 'ngb-highlight',
        changeDetection: ChangeDetectionStrategy.OnPush,
        template: `<template ngFor [ngForOf]="parts" let-part let-isOdd="odd">` +
            `<span *ngIf="isOdd" class="{{highlightClass}}">{{part}}</span><template [ngIf]="!isOdd">{{part}}</template>` +
            `</template>`,
        styles: [`
    .ngb-highlight {
      font-weight: bold;
    }
  `]
    }), 
    __metadata('design:paramtypes', [])
], NgbHighlight);

//# sourceMappingURL=highlight.js.map
