var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Directive, Input, Output, EventEmitter, ComponentFactoryResolver, ViewContainerRef, Injector, Renderer, ElementRef, TemplateRef, forwardRef } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { Subject } from 'rxjs/Rx';
import 'rxjs/add/operator/do';
import 'rxjs/add/operator/let';
import { Positioning } from '../util/positioning';
import { NgbTypeaheadWindow } from './typeahead-window';
import { PopupService } from '../util/popup';
import { toString } from '../util/util';
var Key;
(function (Key) {
    Key[Key["Tab"] = 9] = "Tab";
    Key[Key["Enter"] = 13] = "Enter";
    Key[Key["Escape"] = 27] = "Escape";
    Key[Key["ArrowUp"] = 38] = "ArrowUp";
    Key[Key["ArrowDown"] = 40] = "ArrowDown";
})(Key || (Key = {}));
const NGB_TYPEAHEAD_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => NgbTypeahead),
    multi: true
};
/**
 * NgbTypeahead directive provides a simple way of creating powerful typeaheads from any text input
 */
export let NgbTypeahead = class NgbTypeahead {
    constructor(_elementRef, _viewContainerRef, _renderer, _injector, componentFactoryResolver) {
        this._elementRef = _elementRef;
        this._viewContainerRef = _viewContainerRef;
        this._renderer = _renderer;
        this._injector = _injector;
        this._positioning = new Positioning();
        this._valueChanges = new Subject();
        /**
         * Show hint when an option in the result list matches.
         */
        this.showHint = false;
        /**
         * An event emitted when a match is selected. Event payload is equal to the selected item.
         */
        this.selectItem = new EventEmitter();
        this.onChange = (value) => {
            this._onChangeNoEmit(value);
            this._valueChanges.next(value);
        };
        this.onTouched = () => { };
        this._popupService = new PopupService(NgbTypeaheadWindow, _injector, _viewContainerRef, _renderer, componentFactoryResolver);
        this._onChangeNoEmit = (_) => { };
    }
    ngAfterViewChecked() {
        if (this._windowRef) {
            const targetPosition = this._positioning.positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, 'bottom-left', false);
            const targetStyle = this._windowRef.location.nativeElement.style;
            targetStyle.top = `${targetPosition.top}px`;
            targetStyle.left = `${targetPosition.left}px`;
        }
    }
    ngOnDestroy() { this._subscription.unsubscribe(); }
    ngOnInit() {
        this._subscription =
            this._valueChanges.do(value => this._userInput = value).let(this.ngbTypeahead).subscribe((results) => {
                if (!results || results.length === 0) {
                    this._closePopup();
                }
                else {
                    this._openPopup();
                    this._windowRef.instance.results = results;
                    this._windowRef.instance.term = this._elementRef.nativeElement.value;
                    if (this.resultFormatter) {
                        this._windowRef.instance.formatter = this.resultFormatter;
                    }
                    if (this.resultTemplate) {
                        this._windowRef.instance.resultTemplate = this.resultTemplate;
                    }
                    this._showHint();
                }
            });
    }
    registerOnChange(fn) { this._onChangeNoEmit = fn; }
    registerOnTouched(fn) { this.onTouched = fn; }
    writeValue(value) { this._writeInputValue(this._formatItemForInput(value)); }
    /**
     * @internal
     */
    dismissPopup() {
        if (this.isPopupOpen()) {
            this._closePopup();
            this._writeInputValue(this._userInput);
        }
    }
    /**
     * @internal
     */
    isPopupOpen() { return this._windowRef != null; }
    /**
     * @internal
     */
    handleKeyDown(event) {
        if (!this._windowRef) {
            return;
        }
        if (Key[toString(event.which)]) {
            event.preventDefault();
            switch (event.which) {
                case Key.ArrowDown:
                    this._windowRef.instance.next();
                    this._showHint();
                    break;
                case Key.ArrowUp:
                    this._windowRef.instance.prev();
                    this._showHint();
                    break;
                case Key.Enter:
                case Key.Tab:
                    const result = this._windowRef.instance.getActive();
                    this._selectResult(result);
                    break;
                case Key.Escape:
                    this.dismissPopup();
                    break;
            }
        }
    }
    _openPopup() {
        if (!this._windowRef) {
            this._windowRef = this._popupService.open();
            this._windowRef.instance.selectEvent.subscribe((result) => this._selectResult(result));
        }
    }
    _closePopup() {
        this._popupService.close();
        this._windowRef = null;
    }
    _selectResult(result) {
        this.writeValue(result);
        this._onChangeNoEmit(result);
        this.selectItem.emit(result);
        this._closePopup();
    }
    _showHint() {
        if (this.showHint) {
            const userInputLowerCase = this._userInput.toLowerCase();
            const formattedVal = this._formatItemForInput(this._windowRef.instance.getActive());
            if (userInputLowerCase === formattedVal.substr(0, this._userInput.length).toLowerCase()) {
                this._writeInputValue(this._userInput + formattedVal.substr(this._userInput.length));
                this._renderer.invokeElementMethod(this._elementRef.nativeElement, 'setSelectionRange', [this._userInput.length, formattedVal.length]);
            }
            else {
                this.writeValue(this._windowRef.instance.getActive());
            }
        }
    }
    _formatItemForInput(item) {
        return item && this.inputFormatter ? this.inputFormatter(item) : toString(item);
    }
    _writeInputValue(value) {
        this._renderer.setElementProperty(this._elementRef.nativeElement, 'value', value);
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Function)
], NgbTypeahead.prototype, "inputFormatter", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Function)
], NgbTypeahead.prototype, "ngbTypeahead", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Function)
], NgbTypeahead.prototype, "resultFormatter", void 0);
__decorate([
    Input(), 
    __metadata('design:type', TemplateRef)
], NgbTypeahead.prototype, "resultTemplate", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTypeahead.prototype, "showHint", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbTypeahead.prototype, "selectItem", void 0);
NgbTypeahead = __decorate([
    Directive({
        selector: 'input[ngbTypeahead]',
        host: {
            '(blur)': 'onTouched()',
            '[class.open]': 'isPopupOpen()',
            '(document:click)': 'dismissPopup()',
            '(input)': 'onChange($event.target.value)',
            '(keydown)': 'handleKeyDown($event)',
            'autocomplete': 'off',
            'autocapitalize': 'off',
            'autocorrect': 'off'
        },
        providers: [NGB_TYPEAHEAD_VALUE_ACCESSOR]
    }), 
    __metadata('design:paramtypes', [ElementRef, ViewContainerRef, Renderer, Injector, ComponentFactoryResolver])
], NgbTypeahead);
export const NGB_TYPEAHEAD_DIRECTIVES = [NgbTypeahead];

//# sourceMappingURL=typeahead.js.map
