"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var util_1 = require('../util/util');
var modal_backdrop_1 = require('./modal-backdrop');
var modal_window_1 = require('./modal-window');
var modal_stack_1 = require('./modal-stack');
var modal_ref_1 = require('./modal-ref');
var ModalContentContext = (function () {
    function ModalContentContext() {
    }
    ModalContentContext.prototype.close = function (result) { };
    ModalContentContext.prototype.dismiss = function (reason) { };
    return ModalContentContext;
}());
var NgbModalContainer = (function () {
    function NgbModalContainer(_injector, _renderer, _viewContainerRef, componentFactoryResolver, ngbModalStack) {
        this._injector = _injector;
        this._renderer = _renderer;
        this._viewContainerRef = _viewContainerRef;
        this._backdropFactory = componentFactoryResolver.resolveComponentFactory(modal_backdrop_1.NgbModalBackdrop);
        this._windowFactory = componentFactoryResolver.resolveComponentFactory(modal_window_1.NgbModalWindow);
        ngbModalStack.registerContainer(this);
    }
    NgbModalContainer.prototype.open = function (content, options) {
        var modalContentContext = new ModalContentContext();
        var nodes = this._getContentNodes(content, modalContentContext);
        var windowCmptRef = this._viewContainerRef.createComponent(this._windowFactory, 0, this._injector, nodes);
        var backdropCmptRef;
        var ngbModalRef;
        if (options.backdrop !== false) {
            backdropCmptRef = this._viewContainerRef.createComponent(this._backdropFactory, 0, this._injector);
        }
        ngbModalRef = new modal_ref_1.NgbModalRef(this._viewContainerRef, windowCmptRef, backdropCmptRef);
        modalContentContext.close = function (result) { ngbModalRef.close(result); };
        modalContentContext.dismiss = function (reason) { ngbModalRef.dismiss(reason); };
        this._applyWindowOptions(windowCmptRef.instance, options);
        return ngbModalRef;
    };
    NgbModalContainer.prototype._applyWindowOptions = function (windowInstance, options) {
        ['backdrop', 'keyboard', 'size'].forEach(function (optionName) {
            if (util_1.isDefined(options[optionName])) {
                windowInstance[optionName] = options[optionName];
            }
        });
    };
    NgbModalContainer.prototype._getContentNodes = function (content, context) {
        if (!content) {
            return [];
        }
        else if (content instanceof core_1.TemplateRef) {
            return [this._viewContainerRef.createEmbeddedView(content, context).rootNodes];
        }
        else {
            return [[this._renderer.createText(null, "" + content)]];
        }
    };
    NgbModalContainer = __decorate([
        core_1.Directive({ selector: 'template[ngbModalContainer]' }), 
        __metadata('design:paramtypes', [core_1.Injector, core_1.Renderer, core_1.ViewContainerRef, core_1.ComponentFactoryResolver, modal_stack_1.NgbModalStack])
    ], NgbModalContainer);
    return NgbModalContainer;
}());
exports.NgbModalContainer = NgbModalContainer;

//# sourceMappingURL=modal-container.js.map
